/*
 * Decompiled with CFR 0.152.
 */
package aot.view;

import aot.storage.Storage;
import aot.view.Environment;
import aot.view.Event;
import aot.view.EventFilter;
import aot.view.EventMixer;
import aot.view.EventSource;
import aot.view.Version;
import java.util.Iterator;
import java.util.TreeMap;

public class Application
implements Iterable<Version>,
EventSource {
    protected final Environment environment;
    protected final String id;
    protected final Storage storage;

    protected Application(Environment environment, String id) {
        this.environment = environment;
        this.id = id;
        this.storage = environment.getDataStorage().substorage(String.format("/%s", id));
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getId() {
        return this.id;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public TreeMap<String, Version> getVersions() {
        return this.getVersions(null);
    }

    public TreeMap<String, Version> getVersions(String filter) {
        TreeMap<String, Version> versions = new TreeMap<String, Version>();
        for (String versionId : this.storage.find("", filter)) {
            Version version = new Version(this, versionId);
            versions.put(version.getId(), version);
        }
        return versions;
    }

    @Override
    public Iterator<Version> iterator() {
        return this.getVersions().values().iterator();
    }

    @Override
    public Iterable<Event> getEvents(EventFilter filter) {
        return new EventMixer(filter, this.getVersions(filter.getVersion()).values());
    }
}

