/*
 * Decompiled with CFR 0.152.
 */
package aot.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class XmlUtil {
    public static final String APPLICATION_XML = "application/xml";
    private static final XmlFactory factory = new XmlFactory();
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);

    private XmlUtil() {
    }

    public static byte[] toBytes(Object value) {
        try {
            return mapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromBytes(byte[] data, Class<T> type) {
        try {
            return (T)mapper.readValue(data, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeBytes(OutputStream output, Object value) {
        try {
            mapper.writeValue(output, value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readBytes(InputStream input, Class<T> type) {
        try {
            return (T)mapper.readValue(input, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(Object value) {
        try {
            return mapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromString(String content, Class<T> type) {
        try {
            return (T)mapper.readValue(content, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

