/*
 * Decompiled with CFR 0.152.
 */
package aot.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class TimeUtil {
    public static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");

    private TimeUtil() {
    }

    public static long currentMicro() {
        return System.nanoTime() / 1000L;
    }

    public static Timestamp currentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String format(long time) {
        return String.format("%1$tY.%1$tm.%1$td %1$tH:%1$tM:%1$tS.%1$tL", time);
    }

    public static String formatPath(long time) {
        GregorianCalendar calendar = new GregorianCalendar(TIMEZONE_UTC);
        calendar.setTimeInMillis(time);
        return String.format("/%04d/%02d/%02d/%02d/%02d/%02d/%03d", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(10), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public static String formatMicroSpan(long time) {
        long timeHigh = time / 1000L;
        long timeLow = time % 1000L;
        return String.format("%d.%03d", timeHigh, timeLow);
    }

    public static Date parseDate(String date) {
        try {
            if (date != null) {
                String[] items = date.split("/");
                Calendar calendar = Calendar.getInstance();
                calendar.set(Integer.parseInt(items[2]), Integer.parseInt(items[0]) - 1, Integer.parseInt(items[1]));
                return new Date(calendar.getTimeInMillis());
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Integer getAge(Date dateOfBirth) {
        try {
            if (dateOfBirth != null) {
                GregorianCalendar today = new GregorianCalendar(TIMEZONE_UTC);
                GregorianCalendar birthDate = new GregorianCalendar(TIMEZONE_UTC);
                birthDate.setTime(dateOfBirth);
                int age = today.get(1) - birthDate.get(1);
                if (age > 0) {
                    return age;
                }
                return null;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

