/*
 * Decompiled with CFR 0.152.
 */
package aot.util;

import aot.util.ThreadInterruptedException;
import aot.util.ThreadShutdownException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadUtil {
    private static final Object sleep = new Object();
    private static final AtomicLong threads = new AtomicLong(0L);
    private static final AtomicBoolean shutdown = new AtomicBoolean(false);

    private ThreadUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(long timeout) {
        block10: {
            if (!shutdown.get()) {
                try {
                    Object object = sleep;
                    synchronized (object) {
                        if (!shutdown.get()) {
                            sleep.wait(timeout);
                            if (shutdown.get()) {
                                throw new ThreadShutdownException();
                            }
                        } else {
                            throw new ThreadShutdownException();
                        }
                        break block10;
                    }
                }
                catch (InterruptedException e) {
                    if (!shutdown.get()) {
                        throw new ThreadInterruptedException(e);
                    }
                    throw new ThreadShutdownException(e);
                }
            }
            throw new ThreadShutdownException();
        }
    }

    public static long lock() {
        return threads.incrementAndGet();
    }

    public static long unlock() {
        return threads.decrementAndGet();
    }

    public static boolean isShutdown() {
        return shutdown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shutdown() {
        if (!shutdown.get()) {
            Object object = sleep;
            synchronized (object) {
                if (!shutdown.get()) {
                    shutdown.set(true);
                    sleep.notifyAll();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ThreadUtil.shutdown();
                while (threads.get() > 0L) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
    }
}

