/*
 * Decompiled with CFR 0.152.
 */
package aot.util;

import aot.util.NotFoundException;
import aot.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] findAsBytes(Class clazz, String name) {
        InputStream input = clazz.getResourceAsStream(name);
        if (input == null) return null;
        try (InputStream input1 = input;){
            byte[] data = new byte[input1.available()];
            int read = input1.read(data);
            if (read == data.length) {
                byte[] byArray = data;
                return byArray;
            }
            throw new RuntimeException(String.format("Read %d bytes from resource '%s:%s' of size %d", read, clazz.getName(), name, data.length));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] getAsBytes(Class clazz, String name) {
        byte[] b = ResourceUtil.findAsBytes(clazz, name);
        if (b != null) {
            return b;
        }
        throw new NotFoundException(String.format("Resource '%s:%s' is not found", clazz.getName(), name));
    }

    public static String findAsString(Class clazz, String name) {
        byte[] b = ResourceUtil.findAsBytes(clazz, name);
        if (b != null) {
            return new String(b, StringUtil.CHARSET_UTF8);
        }
        return null;
    }

    public static String getAsString(Class clazz, String name) {
        String s = ResourceUtil.findAsString(clazz, name);
        if (s != null) {
            return s;
        }
        throw new NotFoundException(String.format("Resource '%s:%s' is not found", clazz.getName(), name));
    }
}

