/*
 * Decompiled with CFR 0.152.
 */
package aot.util;

import aot.util.NotFoundException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public final class MapUtil {
    private MapUtil() {
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        throw new NotFoundException(String.format("Entry with key '%s' is not found", key));
    }

    public static <K, V> V putIfAbsent(ConcurrentMap<K, V> map, K key, V value) {
        V v = map.putIfAbsent(key, value);
        if (v != null) {
            return v;
        }
        return value;
    }
}

