/*
 * Decompiled with CFR 0.152.
 */
package aot.util;

import aot.util.NotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class ManifestUtil {
    private static final Map<String, String> attributes;

    private ManifestUtil() {
    }

    public static String findAttribute(String key) {
        return attributes.get(key);
    }

    public static String getAttribute(String key) {
        String v = ManifestUtil.findAttribute(key);
        if (v != null) {
            return v;
        }
        throw new NotFoundException(String.format("Attribute with key '%s' is not found", key));
    }

    public static String getAttribute(String key, String value) {
        String v = ManifestUtil.findAttribute(key);
        if (v != null) {
            return v;
        }
        return value;
    }

    public static Map<String, String> getAttributes() {
        return attributes;
    }

    static {
        try {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>(256);
            Enumeration<URL> resources = ManifestUtil.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                InputStream in = resources.nextElement().openStream();
                Throwable throwable = null;
                try {
                    Manifest manifest = new Manifest(in);
                    for (Map.Entry<Object, Object> attr : manifest.getMainAttributes().entrySet()) {
                        Object key = attr.getKey();
                        Object value = attr.getValue();
                        if (!(key instanceof Attributes.Name) || !(value instanceof String)) continue;
                        attrs.put(key.toString(), value.toString());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            attributes = Collections.unmodifiableMap(attrs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

