/*
 * Decompiled with CFR 0.152.
 */
package aot.util;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class CacheReference<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final ConcurrentLinkedQueue<WeakReference<CacheReference>> references = new ConcurrentLinkedQueue();
    protected final T referent;
    protected final long span;
    protected final AtomicLong access;

    public CacheReference(T referent, long span) {
        this.referent = referent;
        this.span = span;
        this.access = new AtomicLong(System.currentTimeMillis());
        references.add(new WeakReference<CacheReference>(this));
    }

    public T getReferent() {
        return this.referent;
    }

    public long getSpan() {
        return this.span;
    }

    public long getAccess() {
        return this.access.get();
    }

    public T get() {
        this.access.set(System.currentTimeMillis());
        return this.referent;
    }
}

