/*
 * Decompiled with CFR 0.152.
 */
package aot.storage;

import aot.util.CborUtil;
import aot.util.JobjUtil;
import aot.util.JsonUtil;
import aot.util.MapUtil;
import aot.util.XmlUtil;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;

public abstract class Storage {
    private static final ConcurrentHashMap<String, Holder> storages = new ConcurrentHashMap(4096);
    protected final String bucket;
    protected final String prefix;

    protected Storage(String bucket, String prefix) {
        this.bucket = bucket;
        this.prefix = prefix;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public abstract Storage substorage(String var1);

    public abstract Iterable<String> find(String var1);

    public abstract Iterable<String> find(String var1, String var2);

    public abstract Iterable<String> find(String var1, Pattern var2);

    public abstract byte[] get(String var1);

    public abstract void put(String var1, byte[] var2);

    public abstract void delete(String var1);

    public abstract String publish(String var1);

    public abstract void hide(String var1);

    public abstract String url(String var1);

    public <T> T getCbor(String key, Class<T> type) {
        return CborUtil.fromBytes(this.get(key), type);
    }

    public <T> T getJobj(String key, Class<T> type) {
        return JobjUtil.fromBytes(this.get(key), type);
    }

    public <T> T getJson(String key, Class<T> type) {
        return JsonUtil.fromBytes(this.get(key), type);
    }

    public <T> T getXml(String key, Class<T> type) {
        return XmlUtil.fromBytes(this.get(key), type);
    }

    public static Storage createStorage(String id) {
        try {
            String[] ids = id.split("|");
            URL url = new URL(ids[0]);
            String protocol = url.getProtocol();
            return (Storage)Class.forName(String.format("aot.storage.%s.%sStorage", protocol, protocol.toUpperCase())).getConstructor(URL.class, String[].class).newInstance(url, ids);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Storage getStorage(String id) {
        Holder holder = storages.get(id);
        if (holder == null) {
            holder = MapUtil.putIfAbsent(storages, id, new Holder(id, Storage.createStorage(id)));
        }
        return holder.getStorage();
    }

    private static final class Holder {
        private final String id;
        private final Storage storage;
        private final AtomicLong accessTime;

        public Holder(String id, Storage storage) {
            this.id = id;
            this.storage = storage;
            this.accessTime = new AtomicLong(System.currentTimeMillis());
        }

        public String getId() {
            return this.id;
        }

        public Storage getStorage() {
            this.accessTime.set(System.currentTimeMillis());
            return this.storage;
        }

        public long getAccessTime() {
            return this.accessTime.get();
        }
    }
}

