/*
 * Decompiled with CFR 0.152.
 */
package aot.log;

import java.util.LinkedHashMap;

public enum BufferElementType {
    TAGS(-2),
    STRING(-1),
    END(0),
    EVENT(1),
    BINARY_EVENT(2),
    EXCEPTION_EVENT(3),
    START_EVENT(4),
    FINISH_EVENT(5);

    private static final LinkedHashMap<Byte, BufferElementType> events;
    public final byte id;

    private BufferElementType(byte id) {
        this.id = id;
    }

    public static boolean isEvent(Byte id) {
        return events.containsKey(id);
    }

    static {
        events = new LinkedHashMap(64);
        events.put(BufferElementType.EVENT.id, EVENT);
        events.put(BufferElementType.BINARY_EVENT.id, BINARY_EVENT);
        events.put(BufferElementType.EXCEPTION_EVENT.id, EXCEPTION_EVENT);
        events.put(BufferElementType.START_EVENT.id, START_EVENT);
        events.put(BufferElementType.FINISH_EVENT.id, FINISH_EVENT);
    }
}

