/*
 * Decompiled with CFR 0.152.
 */
package aot.log;

import aot.log.BufferElementType;
import aot.log.BufferException;
import aot.storage.Storage;
import aot.util.IOUtil;
import aot.util.MapUtil;
import aot.util.StringUtil;
import aot.util.TimeUtil;
import java.nio.ByteBuffer;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class Buffer {
    public static final int OFFSET = 40;
    private final AtomicInteger threads = new AtomicInteger(0);
    private final AtomicInteger events = new AtomicInteger(0);
    private final AtomicInteger offset = new AtomicInteger(40);
    private final AtomicInteger size = new AtomicInteger(40);
    private final int capacity;
    private final ByteBuffer buffer;
    private final byte[] array;
    private final AtomicLong revision = new AtomicLong(0L);
    private final AtomicLong begin = new AtomicLong(Long.MAX_VALUE);
    private final ConcurrentHashMap<String, Integer> strings = new ConcurrentHashMap(4096);
    private final ThreadLocal<ThreadTags> threadTags = new ThreadLocal<ThreadTags>(){

        @Override
        protected ThreadTags initialValue() {
            return new ThreadTags();
        }
    };

    public Buffer(int capacity) {
        this.capacity = capacity;
        this.buffer = ByteBuffer.allocate(capacity);
        this.array = this.buffer.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int log(long time, String logger, short shift, long tagsRevision, Map<String, String> tags, String message) {
        if (this.offset.get() < this.capacity) {
            this.threads.incrementAndGet();
            try {
                int n = this.putEvent(time, this.putString(logger), shift, this.putTags(tagsRevision, tags), message);
                return n;
            }
            finally {
                this.threads.decrementAndGet();
            }
        }
        throw new BufferException();
    }

    private int putString(String string) {
        Integer off = this.strings.get(string);
        if (off == null) {
            byte[] sd = string.getBytes(StringUtil.CHARSET_UTF8);
            int l = sd.length + 5;
            int o = this.offset.getAndAdd(l);
            if (o + l < this.capacity) {
                this.size.getAndAdd(l);
                this.buffer.put(o, BufferElementType.STRING.id);
                this.buffer.putInt(o + 1, l - 5);
                System.arraycopy(sd, 0, this.array, o + 5, sd.length);
                return MapUtil.putIfAbsent(this.strings, string, o);
            }
            throw new BufferException();
        }
        return off;
    }

    private int putTags(long tagsRevision, Map<String, String> tags) {
        long bufferRevision = this.revision.get();
        ThreadTags tts = this.threadTags.get();
        if (tts.bufferRevision != bufferRevision || tts.tagsRevision != tagsRevision) {
            int l = tags.size() * 4 * 2 + 5;
            int o = this.offset.getAndAdd(l);
            if (o + l < this.capacity) {
                this.size.getAndAdd(l);
                this.buffer.put(o, BufferElementType.TAGS.id);
                this.buffer.putInt(o + 1, l - 5);
                int i = 0;
                for (Map.Entry<String, String> tag : tags.entrySet()) {
                    this.buffer.putInt(o + 5 + i, this.putString(tag.getKey()));
                    this.buffer.putInt(o + 5 + i + 1, this.putString(tag.getValue()));
                    i += 2;
                }
                tts.bufferRevision = bufferRevision;
                tts.tagsRevision = tagsRevision;
                tts.offset = o;
                return o;
            }
            throw new BufferException();
        }
        return tts.offset;
    }

    private int putEvent(long time, int logger, short shift, int tags, String message) {
        byte[] md = message.getBytes(StringUtil.CHARSET_UTF8);
        int l = md.length + 23;
        int o = this.offset.getAndAdd(l);
        if (o + l < this.capacity) {
            this.size.getAndAdd(l);
            this.buffer.put(o, BufferElementType.EVENT.id);
            this.buffer.putInt(o + 1, l - 5);
            this.buffer.putLong(o + 5, time);
            this.buffer.putInt(o + 13, logger);
            this.buffer.putShort(o + 17, shift);
            this.buffer.putInt(o + 19, tags);
            System.arraycopy(md, 0, this.array, o + 23, md.length);
            if (this.events.incrementAndGet() == 1) {
                this.begin.set(time);
            }
            return o;
        }
        throw new BufferException();
    }

    public boolean upload(Storage storage, long time, long span, AtomicLong lost) {
        if (time - span >= this.begin.get()) {
            this.offset.getAndAdd(this.capacity);
        }
        if (this.offset.get() >= this.capacity) {
            while (this.threads.get() > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            long b = Long.MAX_VALUE;
            long e = Long.MIN_VALUE;
            int es = this.events.get();
            int i = 0;
            int j = 40;
            while (i < es) {
                byte t = this.buffer.get(j);
                if (BufferElementType.isEvent(t)) {
                    long evt = this.buffer.getLong(j + 5);
                    if (evt < b) {
                        b = evt;
                    }
                    if (evt > e) {
                        e = evt;
                    }
                }
                j = j + 1 + this.buffer.getInt(j + 1);
            }
            int s = this.size.get();
            long l = lost.getAndSet(0L);
            this.buffer.putInt(0, 1280263968);
            this.buffer.putInt(4, 65536);
            this.buffer.putLong(8, b);
            this.buffer.putLong(16, e);
            this.buffer.putInt(24, s);
            this.buffer.putInt(28, es);
            this.buffer.putLong(32, l);
            GregorianCalendar calendar = new GregorianCalendar(TimeUtil.TIMEZONE_UTC);
            calendar.setTimeInMillis(b);
            String key = String.format("/%04d/%02d/%02d/%02d/%02d/%02d/%03d/%d-%d-%d-%d-%d.log", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(10), calendar.get(12), calendar.get(13), calendar.get(14), b, e, s, es, l);
            storage.put(key, IOUtil.compress(this.array, 0, s));
            this.strings.clear();
            this.begin.set(Long.MAX_VALUE);
            if (this.revision.get() < Long.MAX_VALUE) {
                this.revision.incrementAndGet();
            } else {
                this.revision.set(0L);
            }
            this.events.set(0);
            this.size.set(40);
            this.offset.set(40);
            return true;
        }
        return false;
    }

    private static final class ThreadTags {
        public long bufferRevision = -1L;
        public long tagsRevision = -1L;
        public int offset = -1;

        private ThreadTags() {
        }
    }
}

