/*
 * Decompiled with CFR 0.152.
 */
package aot.application;

import aot.application.Config;
import aot.application.Initializer;
import aot.storage.Storage;
import aot.util.NotFoundException;
import java.util.concurrent.atomic.AtomicReference;

public final class Root {
    private static final Config baseConfig;
    private static final Storage configLocalStorage;
    private static final Storage configRemoteStorage;
    private static final Storage dataLocalStorage;
    private static final Storage dataRemoteStorage;
    private static final String application;
    private static final String version;
    private static final String instance;
    private static final AtomicReference<Config> config;

    private Root() {
    }

    public static Config getBaseConfig() {
        return baseConfig;
    }

    public static Storage getConfigLocalStorage() {
        return configLocalStorage;
    }

    public static Storage getConfigRemoteStorage() {
        return configRemoteStorage;
    }

    public static Storage getDataLocalStorage() {
        return dataLocalStorage;
    }

    public static Storage getDataRemoteStorage() {
        return dataRemoteStorage;
    }

    public static String getApplication() {
        return application;
    }

    public static String getVersion() {
        return version;
    }

    public static String getInstance() {
        return instance;
    }

    public static Config getConfig() {
        return config.get();
    }

    static {
        Initializer initializer;
        try {
            Class<?> clazz = Class.forName("aot.application.CustomInitializer");
            try {
                initializer = (Initializer)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        catch (ClassNotFoundException e) {
            initializer = new Initializer();
        }
        baseConfig = initializer.getBaseConfig();
        configLocalStorage = initializer.getConfigLocalStorage();
        configRemoteStorage = initializer.getConfigRemoteStorage();
        dataLocalStorage = initializer.getDataLocalStorage();
        dataRemoteStorage = initializer.getDataRemoteStorage();
        application = initializer.getApplication();
        version = initializer.getVersion();
        instance = initializer.getInstance();
        config = new AtomicReference<Object>(null);
        if (configLocalStorage == null) {
            try {
                config.set(configRemoteStorage.getJson(String.format("%s/%s/%s/config.json", application, version, instance), Config.class));
            }
            catch (NotFoundException e1) {
                try {
                    config.set(configRemoteStorage.getJson(String.format("%s/%s/config.json", application, version), Config.class));
                }
                catch (NotFoundException e2) {
                    try {
                        config.set(configRemoteStorage.getJson(String.format("%s/config.json", application), Config.class));
                    }
                    catch (NotFoundException e3) {
                        try {
                            config.set(configRemoteStorage.getJson("config.json", Config.class));
                        }
                        catch (NotFoundException e4) {
                            config.set(baseConfig);
                        }
                    }
                }
            }
        } else {
            try {
                config.set(configLocalStorage.getJson(String.format("%s/%s/%s/config.json", application, version, instance), Config.class));
            }
            catch (NotFoundException e1) {
                try {
                    config.set(configLocalStorage.getJson(String.format("%s/%s/config.json", application, version), Config.class));
                }
                catch (NotFoundException e2) {
                    try {
                        config.set(configLocalStorage.getJson(String.format("%s/config.json", application), Config.class));
                    }
                    catch (NotFoundException e3) {
                        try {
                            config.set(configLocalStorage.getJson("config.json", Config.class));
                        }
                        catch (NotFoundException e4) {
                            config.set(baseConfig);
                        }
                    }
                }
            }
        }
        Thread t = new Thread("aot-root-config"){

            @Override
            public void run() {
                while (true) {
                    if (configLocalStorage == null) {
                        try {
                            config.set(configRemoteStorage.getJson(String.format("%s/%s/%s/config.json", application, version, instance), Config.class));
                        }
                        catch (NotFoundException e1) {
                            try {
                                config.set(configRemoteStorage.getJson(String.format("%s/%s/config.json", application, version), Config.class));
                            }
                            catch (NotFoundException e2) {
                                try {
                                    config.set(configRemoteStorage.getJson(String.format("%s/config.json", application), Config.class));
                                }
                                catch (NotFoundException e3) {
                                    try {
                                        config.set(configRemoteStorage.getJson("config.json", Config.class));
                                    }
                                    catch (NotFoundException e4) {
                                        config.set(baseConfig);
                                    }
                                }
                            }
                        }
                        continue;
                    }
                    try {
                        config.set(configLocalStorage.getJson(String.format("%s/%s/%s/config.json", application, version, instance), Config.class));
                        continue;
                    }
                    catch (NotFoundException e1) {
                        try {
                            config.set(configLocalStorage.getJson(String.format("%s/%s/config.json", application, version), Config.class));
                            continue;
                        }
                        catch (NotFoundException e2) {
                            try {
                                config.set(configLocalStorage.getJson(String.format("%s/config.json", application), Config.class));
                                continue;
                            }
                            catch (NotFoundException e3) {
                                try {
                                    config.set(configLocalStorage.getJson("config.json", Config.class));
                                    continue;
                                }
                                catch (NotFoundException e4) {
                                    config.set(baseConfig);
                                    continue;
                                }
                            }
                        }
                    }
                    break;
                }
            }
        };
        t.start();
    }
}

