/*
 * Decompiled with CFR 0.152.
 */
package aot.application;

import aot.application.Config;
import aot.application.Layer;
import aot.util.ThreadLock;
import aot.util.ThreadUtil;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicReference;

public final class Log {
    private static final AtomicReference<Config> config = new AtomicReference<Object>(null);
    private static final AtomicReference<LinkedHashMap<String, Layer>> layers = new AtomicReference<Object>(null);
    private static final ThreadLocal<ThreadInfo> threadInfo = new ThreadLocal<ThreadInfo>(){

        @Override
        protected ThreadInfo initialValue() {
            return new ThreadInfo();
        }
    };

    private Log() {
    }

    public static void log(String layer, String logger, String message) {
        Layer l = layers.get().get(layer);
        if (l != null) {
            ThreadInfo ti = threadInfo.get();
            l.log(logger, ti.shift, ti.tagsRevision, ti.tags, message);
        }
    }

    public static boolean addTag(String key, String value) {
        ThreadInfo ti = threadInfo.get();
        if (!ti.tags.containsKey(key)) {
            ti.tags.put(key, value);
            ti.tagsRevision = ti.tagsRevision < Long.MAX_VALUE ? ++ti.tagsRevision : 0L;
            return true;
        }
        return false;
    }

    public static boolean removeTag(String key) {
        ThreadInfo ti = threadInfo.get();
        if (ti.tags.remove(key) != null) {
            ti.tagsRevision = ti.tagsRevision < Long.MAX_VALUE ? ++ti.tagsRevision : 0L;
            return true;
        }
        return false;
    }

    static {
        Thread t = new Thread("aot-application-log"){

            @Override
            public void run() {
                try (ThreadLock tl = new ThreadLock();){
                    while (!ThreadUtil.isShutdown()) {
                    }
                }
            }
        };
        t.setDaemon(false);
        t.start();
    }

    private static final class ThreadInfo {
        public short shift = 0;
        public long tagsRevision = 0L;
        public final LinkedHashMap<String, String> tags = new LinkedHashMap();

        private ThreadInfo() {
        }
    }
}

