/*
 * Decompiled with CFR 0.152.
 */
package aot.application;

import aot.log.Buffer;
import aot.log.BufferException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

final class Layer {
    private final String id;
    private final Buffer buffer1;
    private final Buffer buffer2;
    private final AtomicBoolean bufferFlag = new AtomicBoolean(true);
    private final AtomicLong lost = new AtomicLong(0L);

    public Layer(String id, int capacity) {
        this.id = id;
        this.buffer1 = new Buffer(capacity);
        this.buffer2 = new Buffer(capacity);
    }

    public void log(String logger, short shift, long tagsRevision, Map<String, String> tags, String message) {
        if (this.bufferFlag.get()) {
            try {
                this.buffer1.log(System.currentTimeMillis(), logger, shift, tagsRevision, tags, message);
            }
            catch (BufferException e1) {
                try {
                    this.buffer2.log(System.currentTimeMillis(), logger, shift, tagsRevision, tags, message);
                    this.bufferFlag.set(false);
                }
                catch (BufferException e2) {
                    this.lost.incrementAndGet();
                }
            }
        } else {
            try {
                this.buffer2.log(System.currentTimeMillis(), logger, shift, tagsRevision, tags, message);
            }
            catch (BufferException e2) {
                try {
                    this.buffer1.log(System.currentTimeMillis(), logger, shift, tagsRevision, tags, message);
                    this.bufferFlag.set(true);
                }
                catch (BufferException e1) {
                    this.lost.incrementAndGet();
                }
            }
        }
    }
}

