/*
 * Decompiled with CFR 0.152.
 */
package aot.application;

import aot.application.BinaryEvent;
import aot.application.Event;
import aot.application.EventTypeNotFoundException;
import aot.util.CborUtil;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public class EventStream
implements Iterable<Event> {
    protected final HashMap<Integer, String> strings = new HashMap(4096);
    protected final HashMap<Integer, Map<String, String>> tags = new HashMap(4096);
    protected final ByteBuffer buffer;

    public EventStream(byte[] buffer) {
        this.buffer = ByteBuffer.wrap(buffer);
    }

    public int skip(int offset) {
        return offset + 5 + this.getLength(offset);
    }

    public byte getType(int offset) {
        return this.buffer.get(offset);
    }

    public int getLength(int offset) {
        return this.buffer.getInt(offset + 1);
    }

    public byte[] getBytes(int offset) {
        byte[] bytes = new byte[this.getLength(offset)];
        System.arraycopy(this.buffer.array(), offset + 5, bytes, 0, bytes.length);
        return bytes;
    }

    public String getString(int offset) {
        String s = this.strings.get(offset);
        if (s == null) {
            s = CborUtil.fromBytes(this.buffer.array(), offset + 5, this.buffer.getInt(offset + 1), String.class);
            this.strings.put(offset, s);
        }
        return s;
    }

    public Map<String, String> getTags(int offset) {
        Map<String, String> ts = this.tags.get(offset);
        if (ts == null) {
            int[] tsi = CborUtil.fromBytes(this.buffer.array(), offset + 5, this.buffer.getInt(offset + 1), int[].class);
            ts = new TreeMap<String, String>();
            int ci = tsi.length;
            for (int i = 0; i < ci; i += 2) {
                ts.put(this.getString(tsi[i]), this.getString(tsi[i + 1]));
            }
            this.tags.put(offset, ts);
        }
        return ts;
    }

    public Event getEvent(int offset) {
        byte type = this.getType(offset);
        if (type == 3) {
            return Event.valueOf(this.getBytes(offset));
        }
        if (type == 4) {
            return BinaryEvent.valueOf(this.getBytes(offset));
        }
        if (type == 5) {
            return null;
        }
        if (type == 6) {
            return null;
        }
        if (type == 7) {
            return null;
        }
        throw new EventTypeNotFoundException(String.format("Event type '%d' is not found", type));
    }

    @Override
    public Iterator<Event> iterator() {
        return new Iterator<Event>(){
            private int offset = 24;
            private final int size;
            {
                this.size = EventStream.this.buffer.array().length;
            }

            @Override
            public boolean hasNext() {
                while (this.offset < this.size) {
                    if (EventStream.this.getType(this.offset) >= 3) {
                        return true;
                    }
                    this.offset = EventStream.this.skip(this.offset);
                }
                return false;
            }

            @Override
            public Event next() {
                if (this.hasNext()) {
                    return EventStream.this.getEvent(this.offset);
                }
                throw new NoSuchElementException(String.format("Event is not found at offset '%d' of size '%d'", this.offset, this.size));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }
}

