/*
 * Decompiled with CFR 0.152.
 */
package aot.application;

import aot.util.Binariable;
import aot.util.CborUtil;
import aot.util.JsonUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class Config
implements Serializable,
Binariable {
    private static final long serialVersionUID = 1L;
    public final Log log;
    public final Stat stat;

    @JsonCreator
    public Config(@JsonProperty(value="log") Log log, @JsonProperty(value="stat") Stat stat) {
        this.log = log;
        this.stat = stat;
    }

    @Override
    public byte[] toBytes() {
        return CborUtil.toBytes(this);
    }

    public String toString() {
        return JsonUtil.toString(this);
    }

    public static Config valueOf(byte[] bytes) {
        return CborUtil.fromBytes(bytes, Config.class);
    }

    public static Config valueOf(String string) {
        return JsonUtil.fromString(string, Config.class);
    }

    public static class Stat
    implements Serializable {
        private static final long serialVersionUID = 1L;
    }

    public static class Log
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final List<Layer> layers;

        public Log(@JsonProperty(value="layers", required=false) List<Layer> layers) {
            this.layers = Collections.unmodifiableList(layers);
        }

        public static class Layer
        implements Serializable {
            private static final long serialVersionUID = 1L;
            public final String id;
            public final boolean enabled;
            public final int span;
            public final int capacity;

            public Layer(@JsonProperty(value="id", required=true) String id, @JsonProperty(value="enabled", required=true) boolean enabled, @JsonProperty(value="span", required=false, defaultValue="1") int span, @JsonProperty(value="capacity", required=false, defaultValue="1024") int capacity) {
                this.id = id;
                this.enabled = enabled;
                this.span = span;
                this.capacity = capacity;
            }
        }
    }
}

