/*
 * Decompiled with CFR 0.152.
 */
package pro.apphub.aws.cloudwatch.log4j2;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import pro.apphub.aws.cloudwatch.log4j2.Buffer;

final class FlushWait {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final long span;
    private long prev = System.currentTimeMillis();

    public FlushWait(int span) {
        this.span = (long)span * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(AtomicBoolean enabled, Buffer buffer1, Buffer buffer2) {
        long next = this.prev + this.span;
        long time = System.currentTimeMillis();
        if (time < next) {
            this.lock.lock();
            try {
                if (enabled.get() && buffer1.isReady() && buffer2.isReady()) {
                    try {
                        this.condition.await(next - time, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        this.prev = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAll() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAll(Runnable activity) {
        this.lock.lock();
        try {
            activity.run();
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

