/*
 * Decompiled with CFR 0.152.
 */
package pro.apphub.aws.cloudwatch.log4j2;

import com.amazonaws.services.logs.AWSLogsClient;
import com.amazonaws.services.logs.model.DataAlreadyAcceptedException;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import pro.apphub.aws.cloudwatch.log4j2.FlushInfo;
import pro.apphub.aws.cloudwatch.log4j2.FlushWait;

final class Buffer {
    public static final int MAX_BATCH_COUNT = 10000;
    public static final int MAX_BATCH_SIZE = 0x100000;
    private final AtomicBoolean ready = new AtomicBoolean(true);
    private final AtomicInteger threads = new AtomicInteger(0);
    private final AtomicInteger size = new AtomicInteger(0);
    private final int capacity;
    private final ConcurrentLinkedQueue<InputLogEvent> eventsQueue;
    private final ArrayList<InputLogEvent> eventsList;
    private final ArrayList<InputLogEvent> eventsBatch;

    public Buffer(int capacity) {
        this.capacity = capacity;
        this.eventsQueue = new ConcurrentLinkedQueue();
        this.eventsList = new ArrayList(capacity + 1);
        this.eventsBatch = new ArrayList(Math.min(capacity + 1, 10000));
    }

    public boolean isReady() {
        return this.ready.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(InputLogEvent event, FlushWait flushWait) {
        if (this.ready.get()) {
            this.threads.incrementAndGet();
            try {
                if (this.ready.get()) {
                    if (this.size.get() < this.capacity) {
                        int s = this.size.getAndIncrement();
                        if (s < this.capacity) {
                            this.eventsQueue.offer(event);
                            if (s + 1 == this.capacity) {
                                flushWait.signalAll(new Runnable(){

                                    @Override
                                    public void run() {
                                        Buffer.this.ready.set(false);
                                    }
                                });
                            }
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.threads.decrementAndGet();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushInfo flush(AWSLogsClient client, String group, String stream, FlushInfo info, AtomicLong lost) {
        this.ready.set(false);
        try {
            while (this.threads.get() > 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
            if (this.size.get() > 0) {
                try {
                    for (InputLogEvent e : this.eventsQueue) {
                        this.eventsList.add(e);
                    }
                    long l = lost.getAndSet(0L);
                    if (l > 0L) {
                        InputLogEvent e = new InputLogEvent();
                        e.setTimestamp(Long.valueOf(System.currentTimeMillis()));
                        e.setMessage(String.format("[EVENTS_LOST]: %d", l));
                        this.eventsList.add(e);
                    }
                    Collections.sort(this.eventsList, new Comparator<InputLogEvent>(){

                        @Override
                        public int compare(InputLogEvent o1, InputLogEvent o2) {
                            return o1.getTimestamp().compareTo(o2.getTimestamp());
                        }
                    });
                    long lst = info.last;
                    if (lst > 0L) {
                        for (InputLogEvent e : this.eventsList) {
                            if (e.getTimestamp() >= lst) break;
                            e.setTimestamp(Long.valueOf(lst));
                        }
                    }
                    lst = this.eventsList.get(this.eventsList.size() - 1).getTimestamp();
                    String tok = info.token;
                    int c = 0;
                    int s = 0;
                    for (InputLogEvent e : this.eventsList) {
                        int es = e.getMessage().length() * 4 + 26;
                        if (c + 1 < 10000 && s + es < 0x100000) {
                            ++c;
                            s += es;
                            this.eventsBatch.add(e);
                            continue;
                        }
                        tok = this.putEvents(client, group, stream, tok, lost, this.eventsBatch);
                        c = 1;
                        s = es;
                        this.eventsBatch.clear();
                        this.eventsBatch.add(e);
                    }
                    tok = this.putEvents(client, group, stream, tok, lost, this.eventsBatch);
                    FlushInfo flushInfo = new FlushInfo(lst, tok);
                    return flushInfo;
                }
                finally {
                    this.eventsBatch.clear();
                    this.eventsList.clear();
                    this.eventsQueue.clear();
                    this.size.set(0);
                }
            }
            FlushInfo flushInfo = info;
            return flushInfo;
        }
        finally {
            this.ready.set(true);
        }
    }

    private String putEvents(AWSLogsClient client, String group, String stream, String token, AtomicLong lost, ArrayList<InputLogEvent> events) {
        if (!events.isEmpty()) {
            try {
                PutLogEventsRequest req = new PutLogEventsRequest(group, stream, events);
                req.setSequenceToken(token);
                PutLogEventsResult res = client.putLogEvents(req);
                return res.getNextSequenceToken();
            }
            catch (DataAlreadyAcceptedException e) {
                lost.addAndGet(events.size());
                return e.getExpectedSequenceToken();
            }
            catch (InvalidSequenceTokenException e) {
                lost.addAndGet(events.size());
                return e.getExpectedSequenceToken();
            }
            catch (Exception e) {
                lost.addAndGet(events.size());
                return token;
            }
        }
        return token;
    }
}

