/*
 * Decompiled with CFR 0.152.
 */
package apphub.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;

public final class TimeUtil {
    private TimeUtil() {
    }

    public static long microTime() {
        return System.nanoTime() / 1000L;
    }

    public static Timestamp currentTime() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String formatTime(long time) {
        return String.format("%1$tY.%1$tm.%1$td %1$tH:%1$tM:%1$tS.%1$tL", time);
    }

    public static String formatMicroSpan(long time) {
        long timeHigh = time / 1000L;
        long timeLow = time % 1000L;
        return String.format("%d.%03d", timeHigh, timeLow);
    }

    public static Date parseDate(String date) {
        try {
            if (date != null) {
                String[] items = date.split("/");
                Calendar calendar = Calendar.getInstance();
                calendar.set(Integer.parseInt(items[2]), Integer.parseInt(items[0]) - 1, Integer.parseInt(items[1]));
                return new Date(calendar.getTimeInMillis());
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Integer getAge(Date dateOfBirth) {
        try {
            if (dateOfBirth != null) {
                Calendar today = Calendar.getInstance();
                Calendar birthDate = Calendar.getInstance();
                birthDate.setTime(dateOfBirth);
                int age = today.get(1) - birthDate.get(1);
                if (age > 0) {
                    return age;
                }
                return null;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

