/*
 * Decompiled with CFR 0.152.
 */
package apphub.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.core.MediaType;

public final class CborUtil {
    public static final String APPLICATION_CBOR = "application/cbor";
    public static final MediaType APPLICATION_CBOR_TYPE = new MediaType("application", "cbor");
    private static final CBORFactory factory = new CBORFactory();
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);

    private CborUtil() {
    }

    public static byte[] toBytes(Object value) {
        try {
            return mapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromBytes(byte[] data, Class<T> type) {
        try {
            return (T)mapper.readValue(data, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeBytes(OutputStream output, Object value) {
        try {
            mapper.writeValue(output, value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readBytes(InputStream input, Class<T> type) {
        try {
            return (T)mapper.readValue(input, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

