/*
 * Decompiled with CFR 0.152.
 */
package apphub.log;

import apphub.log.Buffer;
import apphub.storage.Storage;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

final class Level
implements Runnable {
    private final String id;
    private final Buffer buffer1;
    private final Buffer buffer2;
    private final AtomicBoolean bufferFlag = new AtomicBoolean(true);
    private final ExecutorService executor;
    private final AtomicLong lost = new AtomicLong(0L);

    Level(String id, int capacity, Storage storage, ExecutorService executor) {
        this.id = id;
        this.buffer1 = new Buffer(capacity, storage);
        this.buffer2 = new Buffer(capacity, storage);
        this.executor = executor;
        executor.execute(this);
    }

    public void log(String logger, String message, LinkedHashMap<String, String> tags) {
        if (this.bufferFlag.get()) {
            if (!this.buffer1.log(logger, message, tags) && !this.buffer2.log(logger, message, tags)) {
                this.lost.incrementAndGet();
            }
        } else if (!this.buffer2.log(logger, message, tags) && !this.buffer1.log(logger, message, tags)) {
            this.lost.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(Buffer buffer, boolean flag) {
        long begin = System.currentTimeMillis();
        buffer.upload(this.lost);
        long span = System.currentTimeMillis() - begin;
        if (span < 60000L) {
            Buffer buffer2 = buffer;
            synchronized (buffer2) {
                try {
                    buffer.wait(60000L - span);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        this.bufferFlag.set(flag);
    }

    @Override
    public void run() {
        while (!this.executor.isShutdown()) {
            try {
                this.upload(this.buffer2, false);
                this.upload(this.buffer1, true);
            }
            catch (Exception exception) {}
        }
    }
}

