/*
 * Decompiled with CFR 0.152.
 */
package apphub.log;

import apphub.storage.Storage;
import apphub.util.IOUtil;
import apphub.util.Util;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class Buffer {
    private final AtomicBoolean ready = new AtomicBoolean(true);
    private final AtomicInteger thread = new AtomicInteger(0);
    private final AtomicInteger offset = new AtomicInteger(24);
    private final AtomicInteger size = new AtomicInteger(0);
    private final int capacity;
    private final ByteBuffer data;
    private final Storage storage;
    private long begin;

    Buffer(int capacity, Storage storage) {
        this.capacity = capacity;
        this.data = ByteBuffer.allocate(capacity);
        this.storage = storage;
        this.data.putInt(0, 1);
        this.begin = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean log(String logger, String message, LinkedHashMap<String, String> tags) {
        block14: {
            if (this.ready.get()) {
                this.thread.incrementAndGet();
                try {
                    if (!this.ready.get()) break block14;
                    String tn = Thread.currentThread().getName();
                    int sz = Buffer.getEventSize(logger, tn, message, tags);
                    if (this.offset.get() + sz <= this.capacity) {
                        int off = this.offset.getAndAdd(sz);
                        if (off + sz <= this.capacity) {
                            long time = System.currentTimeMillis();
                            this.size.addAndGet(sz);
                            int delta = Buffer.putEvent(this.data, off, time, sz, logger, tn, message, tags) - off;
                            if (delta != sz) {
                                throw new Error(String.format("Log event size %s is not equal offset delta %s", sz, delta));
                            }
                            boolean bl = true;
                            return bl;
                        }
                        if (!this.ready.get()) break block14;
                        this.ready.set(false);
                        Buffer buffer = this;
                        synchronized (buffer) {
                            this.notifyAll();
                            break block14;
                        }
                    }
                    if (!this.ready.get()) break block14;
                    this.ready.set(false);
                    Buffer buffer = this;
                    synchronized (buffer) {
                        this.notifyAll();
                    }
                }
                finally {
                    this.thread.decrementAndGet();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(AtomicLong lost) {
        if (this.size.get() > 0) {
            this.ready.set(false);
            try {
                while (this.thread.get() > 0) {
                    Util.sleep(300L);
                }
                int sz = this.size.get();
                this.data.putInt(4, sz);
                this.data.putLong(8, this.begin);
                this.data.putLong(16, lost.getAndSet(0L));
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(this.begin);
                int year = cal.get(1);
                int month = cal.get(2);
                int day = cal.get(5);
                int hour = cal.get(10);
                int minute = cal.get(12);
                int second = cal.get(13);
                int millisecond = cal.get(14);
                String key = String.format("%d/%d/%d/%d/%d/%d-%d-%d_%d:%d:%d.%d", year, month, day, hour, minute, year, month, day, hour, minute, second, millisecond);
                this.storage.put(key, IOUtil.compress(this.data.array(), 0, 24 + sz));
                this.size.set(0);
                this.offset.set(24);
                this.begin = System.currentTimeMillis();
            }
            finally {
                this.ready.set(true);
            }
        }
    }

    private static int getEventSize(String logger, String thread, String message, LinkedHashMap<String, String> tags) {
        int size = 20 + logger.length() + thread.length() + message.length();
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            size += 2 + tag.getKey().length() + tag.getValue().length();
        }
        return size;
    }

    private static int putString(ByteBuffer data, int offset, String value) {
        int l = value.length();
        data.putShort(offset, (short)l);
        offset += 2;
        int ci = l;
        for (int i = 0; i < ci; ++i) {
            data.putChar(offset, value.charAt(i));
            offset += 2;
        }
        return offset;
    }

    private static int putEvent(ByteBuffer data, int offset, long time, int size, String logger, String thread, String message, LinkedHashMap<String, String> tags) {
        data.putLong(offset, time);
        data.putInt(offset += 8, size);
        offset += 4;
        offset = Buffer.putString(data, offset, logger);
        offset = Buffer.putString(data, offset, thread);
        offset = Buffer.putString(data, offset, message);
        data.putShort(offset, (short)tags.size());
        offset += 2;
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            offset = Buffer.putString(data, offset, tag.getKey());
            offset = Buffer.putString(data, offset, tag.getValue());
        }
        return offset;
    }
}

