/*
 * Decompiled with CFR 0.152.
 */
package apphub;

import apphub.Config;
import apphub.util.Util;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public final class Service {
    private static final ResteasyClient client = Config.get().getClientBuilder().build();
    private static final ConcurrentHashMap<Key, Holder> services = new ConcurrentHashMap(256);

    private Service() {
    }

    public static <S> S get(String url, Class<S> type) {
        Key<S> key = new Key<S>(url, type);
        Holder<S> holder = services.get(key);
        if (holder == null) {
            holder = new Holder<S>(key);
            services.putIfAbsent(key, holder);
        }
        return holder.getProxy();
    }

    static {
        Thread t = new Thread("apphub-service"){

            @Override
            public void run() {
                while (!Config.get().isShutdown()) {
                    Util.sleep(60000L);
                    Holder[] holders = services.values().toArray(new Holder[services.size()]);
                    long time = System.currentTimeMillis();
                    for (Holder holder : holders) {
                        if (holder.getAccessTime() + 60000L >= time) continue;
                        services.remove(holder.getKey());
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private static final class Holder<S> {
        private final Key<S> key;
        private final ResteasyWebTarget target;
        private final S proxy;
        private final AtomicLong accessTime;

        public Holder(Key<S> key) {
            this.key = key;
            this.target = client.target(key.getUrl());
            this.proxy = this.target.proxy(key.getType());
            this.accessTime = new AtomicLong(System.currentTimeMillis());
        }

        public Key<S> getKey() {
            return this.key;
        }

        public ResteasyWebTarget getTarget() {
            return this.target;
        }

        public S getProxy() {
            this.accessTime.set(System.currentTimeMillis());
            return this.proxy;
        }

        public long getAccessTime() {
            return this.accessTime.get();
        }
    }

    private static final class Key<S> {
        private final String url;
        private final Class<S> type;

        public Key(String url, Class<S> type) {
            this.url = url;
            this.type = type;
        }

        public String getUrl() {
            return this.url;
        }

        public Class<S> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (!this.type.equals(key.type)) {
                return false;
            }
            return this.url.equals(key.url);
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

