/*
 * Decompiled with CFR 0.152.
 */
package apphub;

import apphub.EnvironmentType;
import apphub.config.Transformer;
import apphub.config.transformer.IntTransformer;
import apphub.protocol.cp.Handler;
import apphub.storage.StorageType;
import apphub.util.PropertyUtil;
import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final Config config = Config.createConfig();
    protected final String domain = PropertyUtil.getSystemProperty("APPHUB_DOMAIN");
    protected final String environment = PropertyUtil.getSystemProperty("APPHUB_ENVIRONMENT");
    protected final EnvironmentType environmentType = EnvironmentType.valueOf(PropertyUtil.getSystemProperty("APPHUB_ENVIRONMENT_TYPE"));
    protected final String environmentDomain = PropertyUtil.getSystemProperty("APPHUB_ENVIRONMENT_DOMAIN");
    protected final StorageType storageType = StorageType.valueOf(PropertyUtil.getSystemProperty("APPHUB_STORAGE_TYPE"));
    protected final String storageProtocol = PropertyUtil.getSystemProperty("APPHUB_STORAGE_PROTOCOL");
    protected final String storageUrl = PropertyUtil.getSystemProperty("APPHUB_STORAGE_URL");
    protected final String serviceDomain = PropertyUtil.getSystemProperty("APPHUB_SERVICE_DOMAIN");
    protected final String serviceUrl = PropertyUtil.getSystemProperty("APPHUB_SERVICE_URL");
    protected final String cdnDomain = PropertyUtil.getSystemProperty("APPHUB_CDN_DOMAIN");
    protected final String cdnUrl = PropertyUtil.getSystemProperty("APPHUB_CDN_URL");
    protected final String jenkinsDomain = PropertyUtil.getSystemProperty("APPHUB_JENKINS_DOMAIN");
    protected final String jenkinsUrl = PropertyUtil.getSystemProperty("APPHUB_JENKINS_URL");
    protected final String providerDomain = PropertyUtil.getSystemProperty("APPHUB_PROVIDER_DOMAIN");
    protected final String instance = PropertyUtil.getSystemProperty("APPHUB_INSTANCE");
    protected final String instanceType = PropertyUtil.getSystemProperty("APPHUB_INSTANCE_TYPE");
    protected final String image = PropertyUtil.getSystemProperty("APPHUB_IMAGE");
    protected final String imageLaunch = PropertyUtil.getSystemProperty("APPHUB_IMAGE_LAUNCH");
    protected final String imageManifest = PropertyUtil.getSystemProperty("APPHUB_IMAGE_MANIFEST");
    protected final String zone = PropertyUtil.getSystemProperty("APPHUB_ZONE");
    protected final String profile = PropertyUtil.getSystemProperty("APPHUB_PROFILE");
    protected final String reservation = PropertyUtil.getSystemProperty("APPHUB_RESERVATION");
    protected final String network = PropertyUtil.getSystemProperty("APPHUB_NETWORK");
    protected final String networkDevice = PropertyUtil.getSystemProperty("APPHUB_NETWORK_DEVICE");
    protected final String networkInterface = PropertyUtil.getSystemProperty("APPHUB_NETWORK_INTERFACE");
    protected final Set<String> publicIps = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(PropertyUtil.getSystemProperty("APPHUB_PUBLIC_IPS").split(" "))));
    protected final Set<String> privateIps = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(PropertyUtil.getSystemProperty("APPHUB_PRIVATE_IPS").split(" "))));
    protected final String publicHostname = PropertyUtil.getSystemProperty("APPHUB_PUBLIC_HOSTNAME");
    protected final String privateHostname = PropertyUtil.getSystemProperty("APPHUB_PRIVATE_HOSTNAME");
    protected final String owner = PropertyUtil.getSystemProperty("APPHUB_OWNER");
    protected final String vpc = PropertyUtil.getSystemProperty("APPHUB_VPC");
    protected final String vpcCidr = PropertyUtil.getSystemProperty("APPHUB_VPC_CIDR");
    protected final String subnet = PropertyUtil.getSystemProperty("APPHUB_SUBNET");
    protected final String subnetCidr = PropertyUtil.getSystemProperty("APPHUB_SUBNET_CIDR");
    protected final Set<String> securityGroups = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(PropertyUtil.getSystemProperty("APPHUB_SECURITY_GROUPS").split(" "))));
    protected final String application;
    protected final String version;
    protected final Map<String, Transformer> transformers = Config.createTransformers();
    protected final Map<String, URLStreamHandler> protocolHandlers = Config.createProtocolHandlers();
    protected final ResteasyClientBuilder clientBuilder = new ResteasyClientBuilder();
    protected final AtomicBoolean shutdown = new AtomicBoolean(false);

    protected Config() {
        this.application = "apphub-dev";
        this.version = "1.0-SNAPSHOT";
    }

    public String getDomain() {
        return this.domain;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public EnvironmentType getEnvironmentType() {
        return this.environmentType;
    }

    public String getEnvironmentDomain() {
        return this.environmentDomain;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public String getStorageProtocol() {
        return this.storageProtocol;
    }

    public String getStorageUrl() {
        return this.storageUrl;
    }

    public String getServiceDomain() {
        return this.serviceDomain;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getCdnDomain() {
        return this.cdnDomain;
    }

    public String getCdnUrl() {
        return this.cdnUrl;
    }

    public String getJenkinsDomain() {
        return this.jenkinsDomain;
    }

    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    public String getProviderDomain() {
        return this.providerDomain;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getImage() {
        return this.image;
    }

    public String getImageLaunch() {
        return this.imageLaunch;
    }

    public String getImageManifest() {
        return this.imageManifest;
    }

    public String getZone() {
        return this.zone;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getReservation() {
        return this.reservation;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getNetworkDevice() {
        return this.networkDevice;
    }

    public String getNetworkInterface() {
        return this.networkInterface;
    }

    public Set<String> getPublicIps() {
        return this.publicIps;
    }

    public Set<String> getPrivateIps() {
        return this.privateIps;
    }

    public String getPublicHostname() {
        return this.publicHostname;
    }

    public String getPrivateHostname() {
        return this.privateHostname;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getVpc() {
        return this.vpc;
    }

    public String getVpcCidr() {
        return this.vpcCidr;
    }

    public String getSubnet() {
        return this.subnet;
    }

    public String getSubnetCidr() {
        return this.subnetCidr;
    }

    public Set<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public String getApplication() {
        return this.application;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Transformer> getTransformers() {
        return this.transformers;
    }

    public Map<String, URLStreamHandler> getProtocolHandlers() {
        return this.protocolHandlers;
    }

    public ResteasyClientBuilder getClientBuilder() {
        return this.clientBuilder;
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    public void shutdown() {
        this.shutdown.compareAndSet(false, true);
    }

    public static Config get() {
        return config;
    }

    private static Config createConfig() {
        try {
            Class<?> clazz = Class.forName("apphub.CustomConfig");
            return (Config)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            return new Config();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<String, Transformer> createTransformers() {
        LinkedHashMap<String, IntTransformer> transformers = new LinkedHashMap<String, IntTransformer>(1);
        IntTransformer t = new IntTransformer();
        transformers.put(t.getType(), t);
        return Collections.unmodifiableMap(transformers);
    }

    private static Map<String, URLStreamHandler> createProtocolHandlers() {
        LinkedHashMap<String, URLStreamHandler> protocolHandlers = new LinkedHashMap<String, URLStreamHandler>(8);
        protocolHandlers.put("app", new apphub.protocol.app.Handler());
        protocolHandlers.put("as", new apphub.protocol.as.Handler());
        protocolHandlers.put("cp", new Handler());
        protocolHandlers.put("env", new apphub.protocol.env.Handler());
        protocolHandlers.put("gs", new apphub.protocol.gs.Handler());
        protocolHandlers.put("inst", new apphub.protocol.inst.Handler());
        protocolHandlers.put("s3", new apphub.protocol.s3.Handler());
        protocolHandlers.put("st", new apphub.protocol.st.Handler());
        return Collections.unmodifiableMap(protocolHandlers);
    }
}

