/*
 * Decompiled with CFR 0.152.
 */
package apphub;

import apphub.Config;
import apphub.Environment;
import apphub.Instance;
import apphub.Property;
import apphub.storage.Storage;
import apphub.util.NotFoundException;
import java.io.Serializable;
import java.util.HashMap;

public final class Application
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Environment environment;
    private final String id;
    private final String url;
    private final HashMap<String, Property> propertiesByIds;
    private final Property[] properties;
    private final HashMap<String, Instance> instancesByIds;
    private final HashMap<String, Instance> instancesByPublicIps;
    private final HashMap<String, Instance> instancesByPrivateIps;
    private final HashMap<String, Instance> instancesByPublicHostnames;
    private final HashMap<String, Instance> instancesByPrivateHostnames;
    private final Instance[] instances;
    private final Storage storage;

    Application(Environment environment, String id, String url, HashMap<String, Property> propertiesByIds, Property[] properties, HashMap<String, Instance> instancesByIds, HashMap<String, Instance> instancesByPublicIps, HashMap<String, Instance> instancesByPrivateIps, HashMap<String, Instance> instancesByPublicHostnames, HashMap<String, Instance> instancesByPrivateHostnames, Instance[] instances, Storage storage) {
        this.environment = environment;
        this.id = id;
        this.url = url;
        this.propertiesByIds = propertiesByIds;
        this.properties = properties;
        this.instancesByIds = instancesByIds;
        this.instancesByPublicIps = instancesByPublicIps;
        this.instancesByPrivateIps = instancesByPrivateIps;
        this.instancesByPublicHostnames = instancesByPublicHostnames;
        this.instancesByPrivateHostnames = instancesByPrivateHostnames;
        this.instances = instances;
        this.storage = storage;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public <V> Property<V> findProperty(Class<V> type, String id) {
        Property prop = this.propertiesByIds.get(id);
        if (prop != null && prop.getType().equals(type)) {
            return prop;
        }
        return null;
    }

    public <V> Property<V> getProperty(Class<V> type, String id) {
        Property<V> prop = this.findProperty(type, id);
        if (prop != null) {
            return prop;
        }
        throw new NotFoundException(String.format("Property of type '%s' with id '%s' is not found", type, id));
    }

    public Property[] getProperties() {
        return (Property[])this.properties.clone();
    }

    public Instance getInstance() {
        return this.getInstance(Config.get().getInstance());
    }

    public Instance findInstance(String id) {
        return this.instancesByIds.get(id);
    }

    public Instance getInstance(String id) {
        Instance inst = this.findInstance(id);
        if (inst != null) {
            return inst;
        }
        throw new NotFoundException(String.format("Instance with id '%s' is not found", id));
    }

    public Instance findInstanceByPublicIp(String ip) {
        return this.instancesByPublicIps.get(ip);
    }

    public Instance getInstanceByPublicIp(String ip) {
        Instance inst = this.findInstanceByPublicIp(ip);
        if (inst != null) {
            return inst;
        }
        throw new NotFoundException(String.format("Instance with public ip '%s' is not found", ip));
    }

    public Instance findInstanceByPrivateIp(String ip) {
        return this.instancesByPrivateIps.get(ip);
    }

    public Instance getInstanceByPrivateIp(String ip) {
        Instance inst = this.findInstanceByPrivateIp(ip);
        if (inst != null) {
            return inst;
        }
        throw new NotFoundException(String.format("Instance with private ip '%s' is not found", ip));
    }

    public Instance findInstanceByPublicHostname(String hostname) {
        return this.instancesByPublicHostnames.get(hostname);
    }

    public Instance getInstanceByPublicHostname(String hostname) {
        Instance inst = this.findInstanceByPublicHostname(hostname);
        if (inst != null) {
            return inst;
        }
        throw new NotFoundException(String.format("Instance with public hostname '%s' is not found", hostname));
    }

    public Instance findInstanceByPrivateHostname(String hostname) {
        return this.instancesByPrivateHostnames.get(hostname);
    }

    public Instance getInstanceByPrivateHostname(String hostname) {
        Instance inst = this.findInstanceByPrivateHostname(hostname);
        if (inst != null) {
            return inst;
        }
        throw new NotFoundException(String.format("Instance with private hostname '%s' is not found", hostname));
    }

    public Instance[] getInstances() {
        return (Instance[])this.instances.clone();
    }

    public Storage getStorage() {
        return this.storage;
    }
}

