/*
 * Copyright (C) 2014 Dmitry Kotlyarov, Dmitriy Rogozhin.
 * All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package apphub.service.api;

import apphub.util.CborUtil;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import java.util.List;

/**
 * @author Dmitry Kotlyarov
 * @since 1.0
 */
@Path("/environment/user/secret")
public interface IEnvironmentUserSecretService {
    @GET
    @Produces(CborUtil.APPLICATION_CBOR)
    public EnvironmentUserSecret get(@HeaderParam("secret") String secret,
                                     @HeaderParam("environment") String environment,
                                     @HeaderParam("user") String user,
                                     @HeaderParam("id") String id);

    @GET
    @Path("/list")
    @Produces(CborUtil.APPLICATION_CBOR)
    public List<EnvironmentUserSecret> list(@HeaderParam("secret") String secret,
                                            @HeaderParam("environment") String environment,
                                            @HeaderParam("user") String user);

    @PUT
    @Consumes(CborUtil.APPLICATION_CBOR)
    @Produces(CborUtil.APPLICATION_CBOR)
    public EnvironmentUserSecret put(@HeaderParam("secret") String secret,
                                     EnvironmentUserSecret environmentUserSecret);

    @POST
    @Consumes(CborUtil.APPLICATION_CBOR)
    @Produces(CborUtil.APPLICATION_CBOR)
    public EnvironmentUserSecret post(@HeaderParam("secret") String secret,
                                      EnvironmentUserSecret environmentUserSecret);

    @DELETE
    @Produces(CborUtil.APPLICATION_CBOR)
    public EnvironmentUserSecret delete(@HeaderParam("secret") String secret,
                                        @HeaderParam("environment") String environment,
                                        @HeaderParam("user") String user,
                                        @HeaderParam("id") String id);
}
