/*
 * Copyright (C) 2014 Dmitry Kotlyarov, Dmitriy Rogozhin.
 * All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package apphub;

import java.io.Serializable;

/**
 * @author Dmitry Kotlyarov
 * @since 1.0
 */
public final class Property<V> implements Serializable {
    private static final long serialVersionUID = 1;

    private final Class<V> type;
    private final String id;
    private final V value;

    Property(Class<V> type, String id, V value) {
        this.type = type;
        this.id = id;
        this.value = value;
    }

    public Class<V> getType() {
        return type;
    }

    public String getId() {
        return id;
    }

    public V getValue() {
        return value;
    }
}
