/*
 * Decompiled with CFR 0.152.
 */
package plus.wcj.libby.http.cache.control.cache;

import java.util.Objects;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.util.StringUtils;
import plus.wcj.libby.http.cache.control.sequence.Sequence;

public class HttpETagCache {
    private final Cache keyCache;
    private final Cache valueCache;
    private final Sequence sequence;
    private static final String KEY_NAME = "eTag:k";
    private static final String VALUE_NAME = "eTag:v";

    public HttpETagCache(CacheManager cacheManager, Sequence sequence) {
        this.sequence = sequence;
        this.keyCache = cacheManager.getCache(KEY_NAME);
        this.valueCache = cacheManager.getCache(VALUE_NAME);
    }

    public String put(String key) {
        if (!StringUtils.hasText((String)key)) {
            return null;
        }
        String eTag = "\"" + this.sequence.nextId() + "\"";
        String oldETag = (String)this.keyCache.get((Object)key, String.class);
        if (StringUtils.hasText((String)oldETag)) {
            this.valueCache.evict((Object)oldETag);
        }
        this.keyCache.put((Object)key, (Object)eTag);
        this.valueCache.put((Object)eTag, (Object)key);
        return eTag;
    }

    public String get(String key) {
        if (!StringUtils.hasText((String)key)) {
            return null;
        }
        return (String)this.keyCache.get((Object)key, String.class);
    }

    public String getOrDefault(String key) {
        if (!StringUtils.hasText((String)key)) {
            return null;
        }
        String eTag = (String)this.keyCache.get((Object)key, String.class);
        return StringUtils.hasText((String)eTag) ? eTag : this.put(key);
    }

    public boolean hasETag(String eTag) {
        if (!StringUtils.hasText((String)eTag)) {
            return false;
        }
        return Objects.nonNull(this.valueCache.get((Object)eTag));
    }
}

