/*
 * Decompiled with CFR 0.152.
 */
package plus.wcj.libby.http.cache.control.aop;

import java.lang.reflect.Method;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.expression.EvaluationContext;
import plus.wcj.libby.http.cache.control.annotation.HttpETagBind;
import plus.wcj.libby.http.cache.control.aop.SpelUtil;
import plus.wcj.libby.http.cache.control.cache.HttpETagCache;

public class HttpETagAdvice
implements AfterReturningAdvice {
    private final HttpETagCache httpETagCache;

    public HttpETagAdvice(HttpETagCache httpETagCache) {
        this.httpETagCache = httpETagCache;
    }

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) {
        EvaluationContext context;
        HttpETagBind httpETagBind = method.getAnnotation(HttpETagBind.class);
        String condition = httpETagBind.condition();
        if (SpelUtil.condition(condition, context = SpelUtil.toEvaluationContext(method, args))) {
            String[] keys;
            String[] spelExpressions = httpETagBind.key();
            for (String key : keys = SpelUtil.parser(context, spelExpressions)) {
                this.httpETagCache.put(key);
            }
        }
    }
}

