/*
 * Decompiled with CFR 0.152.
 */
package plus.wcj.libby.http.cache.control;

import org.springframework.aop.Advisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import plus.wcj.libby.http.cache.control.LibbyControlProperties;
import plus.wcj.libby.http.cache.control.annotation.HttpCacheControl;
import plus.wcj.libby.http.cache.control.aop.HttpAnnotationPointcutAdvisor;
import plus.wcj.libby.http.cache.control.aop.HttpCacheControlAdvice;
import plus.wcj.libby.http.cache.control.cache.HttpETagCache;
import plus.wcj.libby.http.cache.control.filter.HttpIfNoneMatchFilter;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={LibbyControlProperties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class LibbyServletAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"httpCacheControlPointcutAdvisor"})
    @Role(value=2)
    public Advisor httpCacheControlPointcutAdvisor(HttpETagCache httpETagCache, LibbyControlProperties libbyControlProperties) {
        HttpCacheControlAdvice annotationAdvice = new HttpCacheControlAdvice(httpETagCache, libbyControlProperties);
        return new HttpAnnotationPointcutAdvisor(annotationAdvice, HttpCacheControl.class);
    }

    @Bean
    @ConditionalOnMissingBean(name={"httpIfNoneMatchFilter"})
    public HttpIfNoneMatchFilter httpIfNoneMatchFilter(HttpETagCache httpETagCache) {
        return new HttpIfNoneMatchFilter(httpETagCache);
    }
}

