/*
 * Decompiled with CFR 0.152.
 */
package plus.wcj.libby.http.cache.control;

import org.springframework.aop.Advisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import plus.wcj.libby.http.cache.control.annotation.HttpETagBind;
import plus.wcj.libby.http.cache.control.aop.HttpAnnotationPointcutAdvisor;
import plus.wcj.libby.http.cache.control.aop.HttpETagAdvice;
import plus.wcj.libby.http.cache.control.cache.HttpETagCache;
import plus.wcj.libby.http.cache.control.sequence.Sequence;

@Configuration(proxyBeanMethods=false)
public class LibbyETagAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"sequence"})
    @Role(value=2)
    public Sequence sequence() {
        return new Sequence();
    }

    @Bean
    @ConditionalOnMissingBean(name={"cacheManager", "httpETagCache"})
    @Role(value=2)
    public HttpETagCache httpETagCache(Sequence sequence) {
        return new HttpETagCache((CacheManager)new ConcurrentMapCacheManager(), sequence);
    }

    @Bean
    @ConditionalOnMissingBean(name={"HttpETagPointcutAdvisor"})
    @Role(value=2)
    public Advisor HttpETagPointcutAdvisor(HttpETagCache httpETagCache) {
        HttpETagAdvice interceptor = new HttpETagAdvice(httpETagCache);
        return new HttpAnnotationPointcutAdvisor(interceptor, HttpETagBind.class);
    }
}

