/*
 * Decompiled with CFR 0.152.
 */
package plus.wcj.libby.http.cache.control.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import plus.wcj.libby.http.cache.control.cache.HttpETagCache;

public class HttpIfNoneMatchFilter
extends OncePerRequestFilter {
    private final HttpETagCache httpETagCache;

    public HttpIfNoneMatchFilter(HttpETagCache httpETagCache) {
        this.httpETagCache = httpETagCache;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String eTag = request.getHeader("If-None-Match");
        if (StringUtils.hasText((String)eTag) && this.httpETagCache.hasETag(eTag)) {
            response.sendError(HttpStatus.NOT_MODIFIED.value());
            response.flushBuffer();
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

