/*
 * Decompiled with CFR 0.152.
 */
package plus.wcj.libby.http.cache.control.clientconfig;

import java.io.File;
import okhttp3.Cache;
import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.commons.httpclient.HttpClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import plus.wcj.libby.http.cache.control.LibbyControlProperties;

@EnableConfigurationProperties(value={LibbyControlProperties.class})
@ConditionalOnProperty(name={"spring.cloud.httpclientfactories.ok.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={OkHttpClient.class})
@AutoConfigureBefore(value={HttpClientConfiguration.class})
@Configuration(proxyBeanMethods=false)
public class LibbyOkHttpClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OkHttpClient.Builder okHttpClientBuilder(Cache okhttp3Cache) {
        return new OkHttpClient.Builder().cache(okhttp3Cache);
    }

    @Bean
    @ConditionalOnMissingBean
    public Cache okhttp3Cache(LibbyControlProperties libbyControlProperties) {
        LibbyControlProperties.OkHttp okHttp = libbyControlProperties.getOkHttp();
        return new Cache(new File(okHttp.getCacheDirectory()), okHttp.getCacheMaxSize());
    }
}

