/*
 * Decompiled with CFR 0.152.
 */
package plus.wcj.libby.http.cache.control.clientconfig;

import java.io.File;
import java.io.IOException;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.commons.httpclient.HttpClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import plus.wcj.libby.http.cache.control.LibbyControlProperties;

@EnableConfigurationProperties(value={LibbyControlProperties.class})
@AutoConfigureBefore(value={HttpClientConfiguration.class})
@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.cloud.httpclientfactories.apache.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={HttpClient.class}, name={"org.apache.http.impl.client.cache.CachingHttpClientBuilder"})
public class LibbyHttpClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HttpClientBuilder apacheHttpClientBuilder(CacheConfig cacheConfig, LibbyControlProperties libbyControlProperties) throws IOException {
        CachingHttpClientBuilder builder = CachingHttpClientBuilder.create().setCacheConfig(cacheConfig);
        LibbyControlProperties.Httpclient httpclient = libbyControlProperties.getHttpclient();
        if (LibbyControlProperties.CacheType.FILE.equals((Object)httpclient.getCacheType())) {
            File file = new File(httpclient.getCacheDirectory());
            file.mkdirs();
            builder.setCacheDir(file);
        }
        return builder;
    }

    @Bean
    @ConditionalOnMissingBean
    public CacheConfig cacheConfig(LibbyControlProperties libbyControlProperties) {
        LibbyControlProperties.Httpclient httpclient = libbyControlProperties.getHttpclient();
        return CacheConfig.custom().setMaxCacheEntries(httpclient.getMaxCacheEntries()).setMaxObjectSize(httpclient.getMaxObjectSize()).build();
    }
}

