/*
 * Decompiled with CFR 0.152.
 */
package plus.wcj.libby.http.cache.control.aop;

import java.lang.reflect.Method;
import java.util.StringJoiner;
import javax.servlet.http.HttpServletResponse;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import plus.wcj.libby.http.cache.control.LibbyControlProperties;
import plus.wcj.libby.http.cache.control.annotation.HttpCacheControl;
import plus.wcj.libby.http.cache.control.aop.SpelUtil;
import plus.wcj.libby.http.cache.control.cache.HttpETagCache;

public class HttpCacheControlAdvice
implements AfterReturningAdvice {
    private final HttpETagCache httpETagCache;
    private final String defaultCacheControlValue;

    public HttpCacheControlAdvice(HttpETagCache httpETagCache, LibbyControlProperties libbyControlProperties) {
        this.httpETagCache = httpETagCache;
        this.defaultCacheControlValue = this.toCacheControlValue(libbyControlProperties);
    }

    public void afterReturning(Object returnValue, Method method, Object[] args, Object target) {
        HttpServletResponse response = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse();
        HttpCacheControl httpCacheControl = method.getAnnotation(HttpCacheControl.class);
        String spelExpression = httpCacheControl.key();
        String cacheControl = this.toCacheControlValue(httpCacheControl);
        String key = SpelUtil.parser(method, args, spelExpression);
        String eTag = this.httpETagCache.getOrDefault(key);
        response.setHeader("ETag", eTag);
        response.setHeader("Cache-Control", cacheControl);
    }

    private String toCacheControlValue(HttpCacheControl cacheControl) {
        String cacheControlValue;
        StringJoiner stringJoiner = new StringJoiner(", ");
        if (cacheControl.maxAge() != 0L) {
            stringJoiner.add("max-age=" + cacheControl.maxAge());
        }
        if (cacheControl.noCache()) {
            stringJoiner.add("no-cache");
        }
        if (cacheControl.noStore()) {
            stringJoiner.add("no-store");
        }
        if (cacheControl.mustRevalidate()) {
            stringJoiner.add("must-revalidate");
        }
        if (cacheControl.noTransform()) {
            stringJoiner.add("no-transform");
        }
        if (cacheControl.cachePublic()) {
            stringJoiner.add("public");
        }
        if (cacheControl.cachePrivate()) {
            stringJoiner.add("private");
        }
        if (cacheControl.proxyRevalidate()) {
            stringJoiner.add("proxy-revalidate");
        }
        if (cacheControl.sMaxAge() != 0L) {
            stringJoiner.add("s-maxage=" + cacheControl.sMaxAge());
        }
        if (cacheControl.staleIfError() != 0L) {
            stringJoiner.add("stale-if-error=" + cacheControl.staleIfError());
        }
        if (cacheControl.staleWhileRevalidate() != 0L) {
            stringJoiner.add("stale-while-revalidate=" + cacheControl.staleWhileRevalidate());
        }
        return StringUtils.hasLength((String)(cacheControlValue = stringJoiner.toString())) ? cacheControlValue : (StringUtils.hasLength((String)cacheControl.value()) ? cacheControl.value() : this.defaultCacheControlValue);
    }

    private String toCacheControlValue(LibbyControlProperties cacheControl) {
        String cacheControlValue;
        StringJoiner stringJoiner = new StringJoiner(", ");
        if (cacheControl.getMaxAge() != 0L) {
            stringJoiner.add("max-age=" + cacheControl.getMaxAge());
        }
        if (cacheControl.isNoCache()) {
            stringJoiner.add("no-cache");
        }
        if (cacheControl.isNoStore()) {
            stringJoiner.add("no-store");
        }
        if (cacheControl.isMustRevalidate()) {
            stringJoiner.add("must-revalidate");
        }
        if (cacheControl.isNoTransform()) {
            stringJoiner.add("no-transform");
        }
        if (cacheControl.isCachePublic()) {
            stringJoiner.add("public");
        }
        if (cacheControl.isCachePrivate()) {
            stringJoiner.add("private");
        }
        if (cacheControl.isProxyRevalidate()) {
            stringJoiner.add("proxy-revalidate");
        }
        if (cacheControl.getSMaxAge() != 0L) {
            stringJoiner.add("s-maxage=" + cacheControl.getSMaxAge());
        }
        if (cacheControl.getStaleIfError() != 0L) {
            stringJoiner.add("stale-if-error=" + cacheControl.getStaleIfError());
        }
        if (cacheControl.getStaleWhileRevalidate() != 0L) {
            stringJoiner.add("stale-while-revalidate=" + cacheControl.getStaleWhileRevalidate());
        }
        return StringUtils.hasLength((String)(cacheControlValue = stringJoiner.toString())) ? cacheControlValue : cacheControl.getValue();
    }
}

