/*
 * Decompiled with CFR 0.152.
 */
package plus.ojbk.influxdb.core;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import plus.ojbk.influxdb.core.model.BaseModel;
import plus.ojbk.influxdb.util.CommonUtils;

public class Op {
    protected static Logger log = LoggerFactory.getLogger(Op.class);

    public static StringBuilder time(LocalDateTime start, LocalDateTime end) {
        Instant startTime = CommonUtils.parseLocalDateTimeToInstant(start);
        Instant endTime = CommonUtils.parseLocalDateTimeToInstant(end);
        StringBuilder sb = new StringBuilder();
        sb.append("time >='").append(startTime);
        sb.append("' and time <='").append(endTime).append("'");
        return sb;
    }

    public static String where(BaseModel model) {
        StringBuilder sb;
        block8: {
            block7: {
                sb = new StringBuilder();
                if (ObjectUtils.isEmpty((Object)model.getStart()) || ObjectUtils.isEmpty((Object)model.getEnd())) break block7;
                sb = Op.time(model.getStart(), model.getEnd());
                if (ObjectUtils.isEmpty(model.getMap())) break block8;
                for (Map.Entry<String, Object> entry : model.getMap().entrySet()) {
                    sb.append(" and ").append("\"").append(entry.getKey()).append("\"").append("=");
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        sb.append("'").append(value).append("'");
                        continue;
                    }
                    sb.append(entry.getValue());
                }
                break block8;
            }
            if (!ObjectUtils.isEmpty(model.getMap())) {
                int i = 0;
                for (Map.Entry<String, Object> entry : model.getMap().entrySet()) {
                    if (i != 0) {
                        sb.append(" and ");
                    }
                    sb.append("\"").append(entry.getKey()).append("\"").append("=");
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        sb.append("'").append(value).append("'");
                    } else {
                        sb.append(entry.getValue());
                    }
                    ++i;
                }
            }
        }
        return sb.toString();
    }
}

