/*
 * Decompiled with CFR 0.152.
 */
package plus.ojbk.influxdb.core;

import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.Objects;
import org.influxdb.annotation.Column;
import org.influxdb.annotation.Measurement;
import plus.ojbk.influxdb.core.Op;
import plus.ojbk.influxdb.util.CommonUtils;

public class Insert
extends Op {
    public static String build(Object object) {
        Objects.requireNonNull(object, "\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        StringBuilder insert = new StringBuilder();
        String time = "";
        Class<?> clazz = object.getClass();
        Measurement measurement = clazz.getAnnotation(Measurement.class);
        insert.append(measurement.name());
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        for (Field field : fields) {
            try {
                Column column = field.getAnnotation(Column.class);
                field.setAccessible(true);
                if (column.tag()) {
                    if (field.get(object) == null) continue;
                    insert.append(",").append(column.name()).append("=").append(field.get(object));
                    continue;
                }
                if (field.get(object) == null) continue;
                if ("time".equals(column.name())) {
                    time = CommonUtils.parseLocalDateTimeToInstant((LocalDateTime)field.get(object)).getEpochSecond() + "000000000";
                    continue;
                }
                if (i == 0) {
                    insert.append(" ");
                } else {
                    insert.append(",");
                }
                insert.append(column.name()).append("=").append(field.get(object));
                ++i;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error("Influxdb save error. error :{}", (Object)e.getMessage());
            }
        }
        insert.append(" ").append(time);
        String sql = insert.toString();
        log.debug("insert " + sql);
        return sql;
    }
}

