/*
 * Decompiled with CFR 0.152.
 */
package plus.ojbk.influxdb.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.influxdb.InfluxDB;
import org.influxdb.dto.Point;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import plus.ojbk.influxdb.autoconfigure.properties.InfluxdbProperties;
import plus.ojbk.influxdb.util.InfluxdbUtils;

public class InfluxdbTemplate {
    @Autowired
    private InfluxDB influxDB;
    private String database;
    private InfluxdbProperties properties;

    public InfluxdbTemplate(InfluxdbProperties properties) {
        this.properties = properties;
        this.database = properties.getDatabase();
    }

    @PostConstruct
    private void initDefaultDatabase() {
        if (!InfluxdbUtils.checkDatabase(this.execute("show databases"), this.database)) {
            this.execute("create database " + this.database);
        }
    }

    public QueryResult execute(String query) {
        return this.influxDB.query(new Query(query, this.database));
    }

    public <T> List<T> selectList(String query, Class<T> clazz) {
        return InfluxdbUtils.toPOJO(this.execute(query), clazz);
    }

    public long count(String query) {
        return InfluxdbUtils.count(this.execute(query));
    }

    public void insert(List<?> entity) {
        ArrayList<String> data = new ArrayList<String>();
        for (Object object : entity) {
            data.add(InfluxdbUtils.save(object).lineProtocol());
        }
        this.influxDB.write(data);
    }

    public void insert(Object entity) {
        this.influxDB.write(InfluxdbUtils.save(entity));
    }

    public void insert(Map<String, String> tags, Map<String, Object> fields, Long time, String measurement) {
        Point.Builder builder = Point.measurement((String)measurement);
        builder.tag(tags);
        builder.fields(fields);
        if (!ObjectUtils.isEmpty((Object)time)) {
            builder.time(time, TimeUnit.SECONDS);
        }
        this.influxDB.write(this.database, "", builder.build());
    }

    public void insert(String query) {
        this.influxDB.write(query);
    }

    public long delete(String query) {
        return InfluxdbUtils.delete(this.execute(query));
    }
}

