/*
 * Decompiled with CFR 0.152.
 */
package plus.ojbk.influxdb.core;

import java.time.LocalDateTime;
import java.util.Objects;
import java.util.TreeMap;
import org.springframework.util.ObjectUtils;
import plus.ojbk.influxdb.core.Op;
import plus.ojbk.influxdb.core.model.DeleteModel;

public class Delete
extends Op {
    public static String build(DeleteModel model) {
        Objects.requireNonNull(model.getMeasurement(), "DeleteModel.Measurement");
        StringBuilder delete = new StringBuilder();
        delete.append("delete from ").append(model.getMeasurement());
        if (ObjectUtils.isEmpty((Object)model.getWhere())) {
            throw new RuntimeException("where \u6761\u4ef6\u7f3a\u5931");
        }
        delete.append(" where ").append(model.getWhere());
        String sql = delete.toString();
        log.info(sql);
        return sql;
    }

    public static void main(String[] args) throws Exception {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("device_id", "666");
        DeleteModel model = new DeleteModel("ojbk");
        model.setMap(map);
        model.setStart(LocalDateTime.now().plusHours(-10L));
        model.setEnd(LocalDateTime.now());
        model.setWhere(Op.where(model));
        System.err.println(Delete.build(model));
    }
}

