/*
 * Decompiled with CFR 0.152.
 */
package plus.kat.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import plus.kat.Chan;
import plus.kat.anno.NotNull;
import plus.kat.chain.Paper;

public class ChanBuf {
    @NotNull
    public static ByteBuf wrappedBuffer(@NotNull Chan chan) {
        return ChanBuf.wrappedBuffer(chan.getFlow());
    }

    @NotNull
    public static ByteBuf wrappedBuffer(@NotNull Paper flow) {
        int length = flow.length();
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (!flow.isShared()) {
            return Unpooled.wrappedBuffer((byte[])flow.copyBytes());
        }
        byte[] src = flow.getValue();
        if (length == src.length) {
            return Unpooled.wrappedBuffer((byte[])src);
        }
        return Unpooled.wrappedBuffer((byte[])src).slice(0, length);
    }
}

