/*
 * Decompiled with CFR 0.152.
 */
package plus.kat.netty;

import io.netty.buffer.ByteBuf;
import plus.kat.anno.NotNull;
import plus.kat.stream.ByteReader;
import plus.kat.stream.Reader;

public class ByteBufReader
implements Reader {
    private ByteBuf buf;
    private int index;
    private int length;

    public ByteBufReader(@NotNull ByteBuf buf) {
        this.buf = buf;
        this.index = buf.readerIndex();
        this.length = buf.writerIndex();
    }

    public byte read() {
        return this.buf.getByte(this.index++);
    }

    public boolean also() {
        return this.index < this.length;
    }

    public void close() {
        this.buf = null;
        this.length = 0;
    }

    @NotNull
    public static Reader of(@NotNull ByteBuf buf) {
        if (buf.hasArray()) {
            return new ByteReader(buf.array());
        }
        return new ByteBufReader(buf);
    }
}

