/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.websocket.support;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.List;
import java.util.Map;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.RequestParam;
import plus.jdk.websocket.global.WebsocketDispatcher;
import plus.jdk.websocket.support.MethodArgumentResolver;

public class RequestParamMethodArgumentResolver
implements MethodArgumentResolver {
    private AbstractBeanFactory beanFactory;

    public RequestParamMethodArgumentResolver(AbstractBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestParam.class);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, Channel channel, Object object) throws Exception {
        Map requestParams;
        RequestParam ann = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        String name = ann.name();
        if (name.isEmpty() && (name = parameter.getParameterName()) == null) {
            throw new IllegalArgumentException("Name for argument type [" + parameter.getNestedParameterType().getName() + "] not available, and parameter name information not found in class file either.");
        }
        if (!channel.hasAttr(WebsocketDispatcher.REQUEST_PARAM)) {
            QueryStringDecoder decoder = new QueryStringDecoder(((FullHttpRequest)object).uri());
            channel.attr(WebsocketDispatcher.REQUEST_PARAM).set((Object)decoder.parameters());
        }
        List arg = (requestParams = (Map)channel.attr(WebsocketDispatcher.REQUEST_PARAM).get()) != null ? (List)requestParams.get(name) : null;
        TypeConverter typeConverter = this.beanFactory.getTypeConverter();
        if (arg == null) {
            if ("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(ann.defaultValue())) {
                return null;
            }
            return typeConverter.convertIfNecessary((Object)ann.defaultValue(), parameter.getParameterType());
        }
        if (List.class.isAssignableFrom(parameter.getParameterType())) {
            return typeConverter.convertIfNecessary((Object)arg, parameter.getParameterType());
        }
        return typeConverter.convertIfNecessary(arg.get(0), parameter.getParameterType());
    }
}

