/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.websocket.model;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public interface IWsSession<T> {
    public T getUserId();

    public void setUserId(T var1);

    public Channel getChannel();

    public void setChannel(Channel var1);

    default public void setSubProtocols(String subProtocols) {
        this.setAttribute("subprotocols", subProtocols);
    }

    default public ChannelFuture sendText(String message) {
        return this.getChannel().writeAndFlush((Object)new TextWebSocketFrame(message));
    }

    default public ChannelFuture sendText(ByteBuf byteBuf) {
        return this.getChannel().writeAndFlush((Object)new TextWebSocketFrame(byteBuf));
    }

    default public ChannelFuture sendText(ByteBuffer byteBuffer) {
        ByteBuf buffer = this.getChannel().alloc().buffer(byteBuffer.remaining());
        buffer.writeBytes(byteBuffer);
        return this.getChannel().writeAndFlush((Object)new TextWebSocketFrame(buffer));
    }

    default public ChannelFuture sendText(TextWebSocketFrame textWebSocketFrame) {
        return this.getChannel().writeAndFlush((Object)textWebSocketFrame);
    }

    default public ChannelFuture sendBinary(byte[] bytes) {
        ByteBuf buffer = this.getChannel().alloc().buffer(bytes.length);
        return this.getChannel().writeAndFlush((Object)new BinaryWebSocketFrame(buffer.writeBytes(bytes)));
    }

    default public ChannelFuture sendBinary(ByteBuf byteBuf) {
        return this.getChannel().writeAndFlush((Object)new BinaryWebSocketFrame(byteBuf));
    }

    default public ChannelFuture sendBinary(ByteBuffer byteBuffer) {
        ByteBuf buffer = this.getChannel().alloc().buffer(byteBuffer.remaining());
        buffer.writeBytes(byteBuffer);
        return this.getChannel().writeAndFlush((Object)new BinaryWebSocketFrame(buffer));
    }

    default public ChannelFuture sendBinary(BinaryWebSocketFrame binaryWebSocketFrame) {
        return this.getChannel().writeAndFlush((Object)binaryWebSocketFrame);
    }

    default public <T> void setAttribute(String name, T value) {
        AttributeKey sessionIdKey = AttributeKey.valueOf((String)name);
        this.getChannel().attr(sessionIdKey).set(value);
    }

    default public <T> T getAttribute(String name) {
        AttributeKey sessionIdKey = AttributeKey.valueOf((String)name);
        return (T)this.getChannel().attr(sessionIdKey).get();
    }

    default public ChannelId id() {
        return this.getChannel().id();
    }

    default public ChannelConfig config() {
        return this.getChannel().config();
    }

    default public boolean isOpen() {
        return this.getChannel().isOpen();
    }

    default public boolean isRegistered() {
        return this.getChannel().isRegistered();
    }

    default public boolean isActive() {
        return this.getChannel().isActive();
    }

    default public ChannelMetadata metadata() {
        return this.getChannel().metadata();
    }

    default public SocketAddress localAddress() {
        return this.getChannel().localAddress();
    }

    default public SocketAddress remoteAddress() {
        return this.getChannel().remoteAddress();
    }

    default public ChannelFuture closeFuture() {
        return this.getChannel().closeFuture();
    }

    default public boolean isWritable() {
        return this.getChannel().isWritable();
    }

    default public long bytesBeforeUnwritable() {
        return this.getChannel().bytesBeforeUnwritable();
    }

    default public long bytesBeforeWritable() {
        return this.getChannel().bytesBeforeWritable();
    }

    default public Channel.Unsafe unsafe() {
        return this.getChannel().unsafe();
    }

    default public ChannelPipeline pipeline() {
        return this.getChannel().pipeline();
    }

    default public ByteBufAllocator alloc() {
        return this.getChannel().alloc();
    }

    default public Channel read() {
        return this.getChannel().read();
    }

    default public Channel flush() {
        return this.getChannel().flush();
    }

    default public ChannelFuture close() {
        return this.getChannel().close();
    }

    default public ChannelFuture close(ChannelPromise promise) {
        return this.getChannel().close(promise);
    }
}

