/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.websocket.global;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanFactory;
import plus.jdk.websocket.global.HttpServerHandler;
import plus.jdk.websocket.global.IWSSessionAuthenticator;
import plus.jdk.websocket.global.SessionGroupManager;
import plus.jdk.websocket.global.WebsocketMethodMapping;
import plus.jdk.websocket.model.IWsSession;
import plus.jdk.websocket.properties.WebsocketProperties;

public class WebsocketDispatcher {
    private static final Logger log = LoggerFactory.getLogger(WebsocketDispatcher.class);
    private final WebsocketProperties properties;
    private static final AttributeKey<Object> POJO_KEY = AttributeKey.valueOf((String)"WEBSOCKET_IMPLEMENT");
    public static final AttributeKey<IWsSession<?>> SESSION_KEY = AttributeKey.valueOf((String)"WEBSOCKET_SESSION");
    private static final AttributeKey<String> PATH_KEY = AttributeKey.valueOf((String)"WEBSOCKET_PATH");
    public static final AttributeKey<Map<String, String>> URI_TEMPLATE = AttributeKey.valueOf((String)"WEBSOCKET_URI_TEMPLATE");
    public static final AttributeKey<Map<String, List<String>>> REQUEST_PARAM = AttributeKey.valueOf((String)"WEBSOCKET_REQUEST_PARAM");
    private final BeanFactory beanFactory;
    private final ConcurrentHashMap<String, WebsocketMethodMapping> websocketMethodMap = new ConcurrentHashMap();

    public WebsocketDispatcher(WebsocketProperties properties, BeanFactory beanFactory) {
        this.properties = properties;
        this.beanFactory = beanFactory;
    }

    public void registerEndpoint(String path, WebsocketMethodMapping desc) {
        this.websocketMethodMap.put(path, desc);
    }

    public void startSocketServer() {
        String[] corsOrigins = this.properties.getCorsOrigins();
        Boolean corsAllowCredentials = this.properties.getCorsAllowCredentials();
        final CorsConfig corsConfig = this.createCorsConfig(corsOrigins, corsAllowCredentials);
        NioEventLoopGroup master = new NioEventLoopGroup(this.properties.getBossLoopGroupThreads().intValue());
        final NioEventLoopGroup worker = new NioEventLoopGroup(this.properties.getWorkerLoopGroupThreads().intValue());
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group((EventLoopGroup)master, (EventLoopGroup)worker);
        bootstrap.channel(NioServerSocketChannel.class);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.properties.getConnectTimeoutMillis());
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.properties.getSO_BACKLOG());
        bootstrap.option(ChannelOption.WRITE_SPIN_COUNT, (Object)this.properties.getWriteSpinCount());
        bootstrap.handler((ChannelHandler)new LoggingHandler(this.properties.getLogLevel()));
        final WebsocketDispatcher websocketDispatcher = this;
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast("logging", (ChannelHandler)new LoggingHandler("DEBUG"));
                ch.pipeline().addLast("http-codec", (ChannelHandler)new HttpServerCodec());
                ch.pipeline().addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                ch.pipeline().addLast("http-chunked", (ChannelHandler)new ChunkedWriteHandler());
                if (corsConfig != null) {
                    ch.pipeline().addLast(new ChannelHandler[]{new CorsHandler(corsConfig)});
                }
                ch.pipeline().addLast("handler", (ChannelHandler)new HttpServerHandler(WebsocketDispatcher.this.properties, websocketDispatcher, worker, WebsocketDispatcher.this.beanFactory));
            }
        });
        if (this.properties.getChildOptionSoRcvBuf() != -1) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.properties.getChildOptionSoRcvBuf());
        }
        if (this.properties.getChildOptionSoSndBuf() != -1) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.properties.getChildOptionSoSndBuf());
        }
        ChannelFuture channelFuture = bootstrap.bind(this.properties.getPort().intValue());
        log.info("start websocket server {}", (Object)this.properties.getPort());
        channelFuture.addListener(future -> {
            if (!future.isSuccess()) {
                future.cause().printStackTrace();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            master.shutdownGracefully().syncUninterruptibly();
            worker.shutdownGracefully().syncUninterruptibly();
        }));
    }

    private CorsConfig createCorsConfig(String[] corsOrigins, Boolean corsAllowCredentials) {
        if (corsOrigins == null || corsOrigins.length == 0) {
            return null;
        }
        CorsConfigBuilder corsConfigBuilder = null;
        for (String corsOrigin : corsOrigins) {
            if (!"*".equals(corsOrigin)) continue;
            corsConfigBuilder = CorsConfigBuilder.forAnyOrigin();
            break;
        }
        if (corsConfigBuilder == null) {
            corsConfigBuilder = CorsConfigBuilder.forOrigins((String[])corsOrigins);
        }
        if (corsAllowCredentials != null && corsAllowCredentials.booleanValue()) {
            corsConfigBuilder.allowCredentials();
        }
        corsConfigBuilder.allowNullOrigin();
        return corsConfigBuilder.build();
    }

    public boolean hasBeforeHandshake(Channel channel, String path) {
        WebsocketMethodMapping websocketMethodMapping = this.getWebsocketMethodMap().get(path);
        if (websocketMethodMapping == null) {
            return false;
        }
        return websocketMethodMapping.getBeforeHandshake() != null;
    }

    public void doBeforeHandshake(Channel channel, FullHttpRequest req, String path) throws Exception {
        WebsocketMethodMapping methodMapping = this.websocketMethodMap.get(path);
        if (methodMapping == null) {
            return;
        }
        Object implement = methodMapping.getBeanObject();
        channel.attr(POJO_KEY).set(implement);
        this.setSession(channel, req, path);
        channel.attr(PATH_KEY).set((Object)path);
        Method beforeHandshake = methodMapping.getBeforeHandshake();
        if (beforeHandshake != null) {
            try {
                beforeHandshake.invoke(implement, methodMapping.getBeforeHandshakeArgs(channel, req));
            }
            catch (TypeMismatchException e) {
                throw e;
            }
            catch (Throwable t) {
                log.error("{}", (Object)t.getMessage());
            }
        }
    }

    public void doOnOpen(Channel channel, FullHttpRequest req, String path) throws Exception {
        Method onOpenMethod;
        WebsocketMethodMapping methodMapping = this.websocketMethodMap.get(path);
        if (methodMapping == null) {
            return;
        }
        Object implement = channel.attr(POJO_KEY).get();
        if (implement == null) {
            implement = methodMapping.getBeanObject();
            this.setSession(channel, req, path);
        }
        if ((onOpenMethod = methodMapping.getOnOpenMethod()) != null) {
            try {
                onOpenMethod.invoke(implement, methodMapping.getOnOpenArgs(channel, req));
            }
            catch (TypeMismatchException e) {
                throw e;
            }
            catch (Throwable t) {
                log.error("{}", (Object)t.getMessage());
            }
        }
    }

    private void setSession(Channel channel, FullHttpRequest req, String path) throws Exception {
        IWSSessionAuthenticator authenticator = (IWSSessionAuthenticator)this.beanFactory.getBean(this.properties.getSessionAuthenticator());
        SessionGroupManager sessionGroupManager = (SessionGroupManager)this.beanFactory.getBean(SessionGroupManager.class);
        Object wsSession = authenticator.authenticate(channel, req, path);
        channel.attr(SESSION_KEY).set(wsSession);
        sessionGroupManager.addSession(path, (IWsSession<?>)wsSession);
    }

    public void doOnClose(Channel channel) {
        Attribute attrPath = channel.attr(PATH_KEY);
        String path = (String)attrPath.get();
        WebsocketMethodMapping methodMapping = this.websocketMethodMap.get(path);
        if (methodMapping == null) {
            return;
        }
        if (methodMapping.getOnCloseMethod() != null) {
            if (!channel.hasAttr(SESSION_KEY)) {
                return;
            }
            Object implement = channel.attr(POJO_KEY).get();
            try {
                methodMapping.getOnCloseMethod().invoke(implement, methodMapping.getOnCloseArgs(channel));
            }
            catch (Throwable t) {
                log.error("{}", (Object)t.getMessage());
            }
        }
    }

    public void doOnError(Channel channel, Throwable throwable) {
        Attribute attrPath = channel.attr(PATH_KEY);
        String path = (String)attrPath.get();
        WebsocketMethodMapping methodMapping = this.websocketMethodMap.get(path);
        if (methodMapping == null) {
            return;
        }
        if (methodMapping.getOnErrorMethod() != null) {
            if (!channel.hasAttr(SESSION_KEY)) {
                return;
            }
            Object implement = channel.attr(POJO_KEY).get();
            try {
                Method method = methodMapping.getOnErrorMethod();
                Object[] args = methodMapping.getOnErrorArgs(channel, throwable);
                method.invoke(implement, args);
            }
            catch (Throwable t) {
                log.error("{}", (Object)t.getMessage());
            }
        }
    }

    public void doOnMessage(Channel channel, WebSocketFrame frame) {
        Attribute attrPath = channel.attr(PATH_KEY);
        String path = (String)attrPath.get();
        WebsocketMethodMapping methodMapping = this.websocketMethodMap.get(path);
        if (methodMapping == null) {
            return;
        }
        if (methodMapping.getOnMessageMethod() != null) {
            TextWebSocketFrame textFrame = (TextWebSocketFrame)frame;
            Object implement = channel.attr(POJO_KEY).get();
            try {
                methodMapping.getOnMessageMethod().invoke(implement, methodMapping.getOnMessageArgs(channel, textFrame));
            }
            catch (Throwable t) {
                log.error("{}", (Object)t.getMessage());
            }
        }
    }

    public void doOnBinary(Channel channel, WebSocketFrame frame) {
        Attribute attrPath = channel.attr(PATH_KEY);
        String path = (String)attrPath.get();
        WebsocketMethodMapping methodMapping = this.websocketMethodMap.get(path);
        if (methodMapping == null) {
            return;
        }
        if (methodMapping.getOnBinaryMethod() != null) {
            BinaryWebSocketFrame binaryWebSocketFrame = (BinaryWebSocketFrame)frame;
            Object implement = channel.attr(POJO_KEY).get();
            try {
                methodMapping.getOnBinaryMethod().invoke(implement, methodMapping.getOnBinaryArgs(channel, binaryWebSocketFrame));
            }
            catch (Throwable t) {
                log.error("{}", (Object)t.getMessage());
            }
        }
    }

    public void doOnEvent(Channel channel, Object evt) {
        Attribute attrPath = channel.attr(PATH_KEY);
        String path = (String)attrPath.get();
        WebsocketMethodMapping methodMapping = this.websocketMethodMap.get(path);
        if (methodMapping == null) {
            return;
        }
        if (methodMapping.getOnEventMethod() != null) {
            if (!channel.hasAttr(SESSION_KEY)) {
                return;
            }
            Object implement = channel.attr(POJO_KEY).get();
            try {
                methodMapping.getOnEventMethod().invoke(implement, methodMapping.getOnEventArgs(channel, evt));
            }
            catch (Throwable t) {
                log.error("{}", (Object)t.getMessage());
            }
        }
    }

    public ConcurrentHashMap<String, WebsocketMethodMapping> getWebsocketMethodMap() {
        return this.websocketMethodMap;
    }
}

