/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.websocket.global;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plus.jdk.websocket.model.ChannelModel;
import plus.jdk.websocket.model.IWsSession;

public class SessionGroupManager {
    private static final Logger log = LoggerFactory.getLogger(SessionGroupManager.class);
    private final ConcurrentHashMap<Channel, ChannelModel> channelModelMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Object, ConcurrentHashMap<String, ConcurrentLinkedDeque<IWsSession<?>>>> sessionMap = new ConcurrentHashMap();

    protected void addSession(String path, IWsSession<?> iWsSession) {
        Object uid = iWsSession.getUserId();
        this.sessionMap.putIfAbsent(uid, new ConcurrentHashMap());
        this.sessionMap.get(uid).putIfAbsent(path, new ConcurrentLinkedDeque());
        this.sessionMap.get(uid).get(path).add(iWsSession);
        this.channelModelMap.put(iWsSession.getChannel(), new ChannelModel(uid, path));
    }

    public <T> ConcurrentLinkedDeque<IWsSession<?>> getSession(T userId, String path) {
        ConcurrentHashMap<String, ConcurrentLinkedDeque<IWsSession<?>>> userSessionMap = this.sessionMap.get(userId);
        if (userSessionMap == null || userSessionMap.get(path) == null) {
            return new ConcurrentLinkedDeque();
        }
        return this.sessionMap.get(userId).get(path);
    }

    protected void releaseChannel(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        ChannelModel channelModel = this.channelModelMap.get(channel);
        Object uid = channelModel.getUserId();
        String path = channelModel.getPath();
        this.sessionMap.putIfAbsent(uid, new ConcurrentHashMap());
        this.sessionMap.get(uid).putIfAbsent(path, new ConcurrentLinkedDeque());
        ConcurrentLinkedDeque<IWsSession<?>> wsSessionsDeque = this.sessionMap.get(uid).get(path);
        if (wsSessionsDeque == null) {
            return;
        }
        wsSessionsDeque.removeIf(iWsSession -> iWsSession.getChannel() == channel);
    }
}

