/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.websocket.global;

import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.io.ResourceLoader;
import plus.jdk.websocket.annotations.OnWsBinary;
import plus.jdk.websocket.annotations.OnWsClose;
import plus.jdk.websocket.annotations.OnWsError;
import plus.jdk.websocket.annotations.OnWsEvent;
import plus.jdk.websocket.annotations.OnWsHandshake;
import plus.jdk.websocket.annotations.OnWsMessage;
import plus.jdk.websocket.annotations.OnWsOpen;
import plus.jdk.websocket.annotations.WebsocketHandler;
import plus.jdk.websocket.common.ReflectUtils;
import plus.jdk.websocket.global.WebsocketDispatcher;
import plus.jdk.websocket.global.WebsocketMethodMapping;

public class ServerEndpointExporter
extends ApplicationObjectSupport
implements SmartInitializingSingleton,
BeanFactoryAware,
ResourceLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(ServerEndpointExporter.class);
    private final WebsocketDispatcher websocketDispatcher;
    private AbstractBeanFactory beanFactory;
    private ResourceLoader resourceLoader;

    public ServerEndpointExporter(WebsocketDispatcher websocketDispatcher) {
        this.websocketDispatcher = websocketDispatcher;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof AbstractBeanFactory)) {
            throw new IllegalArgumentException("AutowiredAnnotationBeanPostProcessor requires a AbstractBeanFactory: " + beanFactory);
        }
        this.beanFactory = (AbstractBeanFactory)beanFactory;
    }

    public void afterSingletonsInstantiated() {
        String[] endpointBeanNames;
        ApplicationContext context = this.getApplicationContext();
        assert (context != null);
        for (String beanName : endpointBeanNames = context.getBeanNamesForAnnotation(WebsocketHandler.class)) {
            Object beanObject = context.getBean(beanName);
            WebsocketHandler websocketHandler = beanObject.getClass().getAnnotation(WebsocketHandler.class);
            for (String path : websocketHandler.values()) {
                WebsocketMethodMapping websocketMethodMapping = new WebsocketMethodMapping(context, this.beanFactory);
                websocketMethodMapping.setPath(path);
                websocketMethodMapping.setBeanObject(beanObject);
                websocketMethodMapping.setOnOpenMethod(ReflectUtils.getFirstAnnotatedMethod(beanObject, OnWsOpen.class, method -> Modifier.isPublic(method.getModifiers())));
                websocketMethodMapping.setOnMessageMethod(ReflectUtils.getFirstAnnotatedMethod(beanObject, OnWsMessage.class, method -> Modifier.isPublic(method.getModifiers())));
                websocketMethodMapping.setOnCloseMethod(ReflectUtils.getFirstAnnotatedMethod(beanObject, OnWsClose.class, method -> Modifier.isPublic(method.getModifiers())));
                websocketMethodMapping.setBeforeHandshake(ReflectUtils.getFirstAnnotatedMethod(beanObject, OnWsHandshake.class, method -> Modifier.isPublic(method.getModifiers())));
                websocketMethodMapping.setOnErrorMethod(ReflectUtils.getFirstAnnotatedMethod(beanObject, OnWsError.class, method -> Modifier.isPublic(method.getModifiers())));
                websocketMethodMapping.setOnBinaryMethod(ReflectUtils.getFirstAnnotatedMethod(beanObject, OnWsBinary.class, method -> Modifier.isPublic(method.getModifiers())));
                websocketMethodMapping.setOnEventMethod(ReflectUtils.getFirstAnnotatedMethod(beanObject, OnWsEvent.class, method -> Modifier.isPublic(method.getModifiers())));
                websocketMethodMapping.buildParameters();
                log.info("source websocket handler {} success", (Object)path);
                this.websocketDispatcher.registerEndpoint(path, websocketMethodMapping);
            }
        }
        this.websocketDispatcher.startSocketServer();
        log.info("source websocket handler success");
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

