/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.websocket.common;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.HashMap;

public class HttpWsRequest {
    private final FullHttpRequest request;
    private final String uri;
    private final HttpHeaders headers;
    private HashMap<String, String> cookiesMap;
    private HashMap<String, String> queryParams;

    public HttpWsRequest(FullHttpRequest request) {
        this.request = request;
        this.uri = request.uri();
        this.headers = request.headers();
        this.buildCookies();
        this.buildQueryParams();
    }

    public String getCookie(String name) {
        return this.cookiesMap.get(name);
    }

    public String getQueryValue(String name) {
        return this.queryParams.get(name);
    }

    private void buildQueryParams() {
        String[] queryPairArr;
        this.queryParams = new HashMap();
        String uri = this.request.uri();
        String[] tempArr = uri.split("[?]");
        if (tempArr.length < 2) {
            return;
        }
        String queryStr = tempArr[1];
        int hashIndex = queryStr.indexOf("#");
        if (hashIndex > 1) {
            queryStr = queryStr.substring(0, hashIndex);
        }
        for (String queryPairStr : queryPairArr = queryStr.split("&")) {
            String[] queryPair = queryPairStr.split("=");
            String key = queryPair[0];
            String value = queryPair.length > 1 ? queryPair[1] : null;
            this.queryParams.put(key, value);
        }
    }

    private void buildCookies() {
        String[] cookiePairStrArr;
        this.cookiesMap = new HashMap();
        String cookiesStr = this.request.headers().get("Cookie");
        if (cookiesStr == null) {
            return;
        }
        for (String cookiePairStr : cookiePairStrArr = cookiesStr.split(";")) {
            String[] cookiePair = cookiePairStr.split("=");
            String key = cookiePair[0];
            String value = cookiePair.length > 1 ? cookiePair[1] : null;
            this.cookiesMap.put(key, value);
        }
    }

    public FullHttpRequest getRequest() {
        return this.request;
    }

    public String getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }
}

