/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.milvus.wrapper;

import io.milvus.common.clientenum.ConsistencyLevelEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import plus.jdk.milvus.common.MilvusException;
import plus.jdk.milvus.common.Operator;
import plus.jdk.milvus.common.SFunction;
import plus.jdk.milvus.common.StringPool;
import plus.jdk.milvus.common.operator.LogicOperatorComputer;
import plus.jdk.milvus.global.MilvusClientService;
import plus.jdk.milvus.model.WrapperModel;
import plus.jdk.milvus.record.VectorModel;
import plus.jdk.milvus.selector.MilvusSelector;

public abstract class AbstractLambdaWrapper<T extends VectorModel<? extends VectorModel<?>>>
implements StringPool,
Serializable {
    private final List<WrapperModel<T>> wrapperModels = new ArrayList<WrapperModel<T>>();
    protected Class<T> entityType;
    private ConsistencyLevelEnum consistencyLevel = ConsistencyLevelEnum.STRONG;
    private List<String> partitionNames = new ArrayList<String>();
    @Deprecated
    private Long travelTimestamp;
    @Deprecated
    private Long gracefulTime;
    @Deprecated
    private Long ignoreGrowing;

    protected String getTableColumnName(SFunction<?, ?> column, Class<?> clazz) throws MilvusException {
        MilvusClientService milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return milvusClientService.getColumnName(column, clazz);
    }

    public <R> AbstractLambdaWrapper<T> eq(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.eq, value, null));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> le(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.le, value, null));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> lt(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.lt, value, null));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> ge(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.ge, value, null));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> gt(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.gt, value, null));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> ne(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.ne, value, null));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> like(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.like, value, null));
        return this;
    }

    public <R> AbstractLambdaWrapper<T> not_like(SFunction<T, R> column, R value) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.not_like, value, null));
        return this;
    }

    @SafeVarargs
    public final AbstractLambdaWrapper<T> and(AbstractLambdaWrapper<T> ... wrappers) {
        this.wrapperModels.add(new WrapperModel(null, Operator.and, wrappers, null));
        return this;
    }

    @SafeVarargs
    public final AbstractLambdaWrapper<T> or(AbstractLambdaWrapper<T> ... wrappers) {
        this.wrapperModels.add(new WrapperModel(null, Operator.or, wrappers, null));
        return this;
    }

    @SafeVarargs
    public final AbstractLambdaWrapper<T> not(AbstractLambdaWrapper<T> ... wrappers) {
        this.wrapperModels.add(new WrapperModel(null, Operator.not, wrappers, null));
        return this;
    }

    @SafeVarargs
    public final <R> AbstractLambdaWrapper<T> in(SFunction<T, R> column, R ... values) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.in, values, null));
        return this;
    }

    public final <R> AbstractLambdaWrapper<T> contains(SFunction<T, R> column, List<?> values, Object ... identifier) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.contains, values, identifier));
        return this;
    }

    public final <R> AbstractLambdaWrapper<T> contains_all(SFunction<T, R> column, List<?> values, Object ... identifier) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.contains_all, values, identifier));
        return this;
    }

    public final <R> AbstractLambdaWrapper<T> contains_any(SFunction<T, R> column, List<?> values, Object ... identifier) {
        this.wrapperModels.add(new WrapperModel<T>(column, Operator.contains_any, values, identifier));
        return this;
    }

    public String buildExpression(Class<?> clazz) throws MilvusException {
        ArrayList<String> results = new ArrayList<String>();
        for (WrapperModel<T> wrapperModel : this.wrapperModels) {
            Operator operator = wrapperModel.getOperator();
            String columnName = null;
            if (!(operator.getIOperatorComputer() instanceof LogicOperatorComputer)) {
                columnName = this.getTableColumnName(wrapperModel.getColumn(), clazz);
            }
            String compute = operator.getIOperatorComputer().compute(columnName, wrapperModel.getValue(), wrapperModel.getIdentifier(), clazz);
            results.add(compute);
        }
        for (int i = 0; i < results.size(); ++i) {
            if (i == 0) continue;
            if (!Operator.matchAndOr((String)results.get(i))) {
                results.set(i, "and " + (String)results.get(i));
                continue;
            }
            results.set(i, (String)results.get(i));
        }
        return String.join((CharSequence)" ", results);
    }

    public List<WrapperModel<T>> getWrapperModels() {
        return this.wrapperModels;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    public ConsistencyLevelEnum getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    @Deprecated
    public Long getTravelTimestamp() {
        return this.travelTimestamp;
    }

    @Deprecated
    public Long getGracefulTime() {
        return this.gracefulTime;
    }

    @Deprecated
    public Long getIgnoreGrowing() {
        return this.ignoreGrowing;
    }

    public void setEntityType(Class<T> entityType) {
        this.entityType = entityType;
    }

    public void setConsistencyLevel(ConsistencyLevelEnum consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public void setPartitionNames(List<String> partitionNames) {
        this.partitionNames = partitionNames;
    }

    @Deprecated
    public void setTravelTimestamp(Long travelTimestamp) {
        this.travelTimestamp = travelTimestamp;
    }

    @Deprecated
    public void setGracefulTime(Long gracefulTime) {
        this.gracefulTime = gracefulTime;
    }

    @Deprecated
    public void setIgnoreGrowing(Long ignoreGrowing) {
        this.ignoreGrowing = ignoreGrowing;
    }
}

