/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.milvus.record;

import io.milvus.grpc.LoadState;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import plus.jdk.milvus.common.MilvusException;
import plus.jdk.milvus.common.SFunction;
import plus.jdk.milvus.global.MilvusClientService;
import plus.jdk.milvus.model.IIndexExtra;
import plus.jdk.milvus.model.Page;
import plus.jdk.milvus.record.VectorModel;
import plus.jdk.milvus.selector.MilvusSelector;
import plus.jdk.milvus.wrapper.LambdaQueryWrapper;
import plus.jdk.milvus.wrapper.LambdaSearchWrapper;

public abstract class VectorModelRepositoryImpl<T extends VectorModel<? extends VectorModel<?>>>
implements Serializable {
    private final Class<T> entityType;
    private MilvusClientService milvusClientService;

    public VectorModelRepositoryImpl() {
        Type superClass = this.getClass().getGenericSuperclass();
        if (!(superClass instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Unable to determine the entity type.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)superClass;
        this.entityType = (Class)parameterizedType.getActualTypeArguments()[0];
    }

    public boolean insert(T vectorModel) throws MilvusException {
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return this.milvusClientService.insert(vectorModel);
    }

    public boolean remove(Object pk) throws MilvusException {
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return this.milvusClientService.remove(pk, this.entityType);
    }

    public boolean batchRemove(LambdaQueryWrapper<T> wrapper) throws MilvusException {
        wrapper.setEntityType(this.entityType);
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return this.milvusClientService.batchRemove(wrapper);
    }

    public boolean createCollection() throws MilvusException {
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return this.milvusClientService.createCollection(this.entityType);
    }

    public void loadCollection() throws MilvusException {
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        this.milvusClientService.loadCollection(this.entityType);
    }

    public LoadState getLoadState() throws MilvusException {
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return this.milvusClientService.getLoadState(this.entityType);
    }

    public Long getLoadProgress() throws MilvusException {
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return this.milvusClientService.getLoadProgress(this.entityType);
    }

    public void releaseCollection() throws MilvusException {
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        this.milvusClientService.releaseCollection(this.entityType);
    }

    public boolean createIndex(String indexName, SFunction<T, ?> column, IIndexExtra extraParam) throws MilvusException {
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return this.milvusClientService.createIndex(this.entityType, indexName, column, extraParam);
    }

    public boolean dropIndex(String indexName) throws MilvusException {
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return this.milvusClientService.dropIndex(this.entityType, indexName);
    }

    public void dropCollection() throws MilvusException {
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        this.milvusClientService.dropCollection(this.entityType);
    }

    public boolean hasCollection() throws MilvusException {
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return this.milvusClientService.hasCollection(this.entityType);
    }

    public List<T> search(LambdaSearchWrapper<T> wrapper) throws MilvusException {
        wrapper.setEntityType(this.entityType);
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return this.milvusClientService.search(wrapper);
    }

    public List<T> query(LambdaQueryWrapper<T> wrapper) throws MilvusException {
        wrapper.setEntityType(this.entityType);
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return this.milvusClientService.query(wrapper);
    }

    public Page<T> queryPage(LambdaQueryWrapper<T> wrapper, Long page, Long pageSize) throws MilvusException {
        wrapper.setEntityType(this.entityType);
        this.milvusClientService = (MilvusClientService)MilvusSelector.beanFactory.getBean(MilvusClientService.class);
        return this.milvusClientService.queryPage(wrapper, page, pageSize);
    }
}

