/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.milvus.common.operator;

import java.util.ArrayList;
import org.springframework.util.CollectionUtils;
import plus.jdk.milvus.common.MilvusException;
import plus.jdk.milvus.common.operator.IOperatorComputer;
import plus.jdk.milvus.wrapper.AbstractLambdaWrapper;

public class LogicOperatorComputer
implements IOperatorComputer {
    private String operator;

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public String compute(String leftValue, Object rightValue, Object identifier, Class<?> clazz) throws MilvusException {
        AbstractLambdaWrapper[] wrappers = (AbstractLambdaWrapper[])rightValue;
        ArrayList<String> expressions = new ArrayList<String>();
        for (AbstractLambdaWrapper wrapper : wrappers) {
            expressions.add(wrapper.buildExpression(clazz));
        }
        if (CollectionUtils.isEmpty(expressions)) {
            return "";
        }
        return String.format("%s (%s)", this.operator, String.join((CharSequence)" ", expressions));
    }

    public LogicOperatorComputer(String operator) {
        this.operator = operator;
    }
}

